/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.ServerModeConfig;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartBootableJarMojo
extends AbstractServerConnection {
    @Parameter(property="wildfly.bootable.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(property="wildfly.bootable.arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.start.skip")
    private boolean skip;
    @Parameter(alias="check-server-start", defaultValue="true", property="wildfly.bootable.start.check.start")
    private boolean checkStarted;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.bootable.start.timeout")
    private long startupTimeout;
    @Parameter(alias="id", defaultValue="60", property="wildfly.bootable.start.id")
    private String id;
    @Parameter(alias="jar-file-name", property="wildfly.bootable.start.jar.file.name")
    String jarFileName;
    @Parameter(defaultValue="${project.build.directory}/wildfly-jar-start-stdout.log", property="wildfly.bootable.stdout")
    public String stdout;
    @Parameter(alias="server")
    ServerModeConfig server;

    private boolean isJarPackaging() {
        return this.server == null || !this.server.isEnabled();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute(this.project);
    }

    private void doExecute(MavenProject project) throws MojoExecutionException, MojoFailureException {
        block19: {
            Launcher launcher;
            if (this.skip) {
                this.getLog().debug((CharSequence)String.format("Skipping " + this.goal() + " of %s:%s", project.getGroupId(), project.getArtifactId()));
                return;
            }
            boolean inherit = "inherit".equalsIgnoreCase(this.stdout);
            if (this.isJarPackaging()) {
                BootableJarCommandBuilder builder = BootableJarCommandBuilder.of((String)Utils.getBootableJarPath(this.jarFileName, project, this.goal())).addJavaOptions(this.jvmArguments).addServerArguments(this.arguments);
                launcher = Launcher.of((CommandBuilder)builder);
            } else {
                launcher = this.server.createServerLauncher(project, this.jvmArguments, this.arguments, !inherit, this.goal());
            }
            try {
                if (inherit) {
                    launcher.inherit();
                } else {
                    Path redirect = Paths.get(this.stdout, new String[0]);
                    this.getLog().info((CharSequence)String.format("The stdout and stderr for the process are being logged to %s", redirect));
                    launcher.setRedirectErrorStream(true).redirectOutput(redirect);
                }
                Process process = launcher.launch();
                if (!this.checkStarted) break block19;
                try (ModelControllerClient client = this.createClient();){
                    ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), e);
            }
        }
    }

    public String goal() {
        return "start";
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments = Utils.splitArguments(jvmArguments);
    }

    public void setArguments(String arguments) {
        this.arguments = Utils.splitArguments(arguments);
    }
}

