/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.util.IoUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LegacyPatchCleaner {
    private final Path wildflyDir;
    private final Set<Path> existingModules;
    private final Log log;
    private final Path overlays;
    private final Path modulesDir;
    private final Path overlaysFile;
    private final Path patchesDir;

    public LegacyPatchCleaner(Path wildflyDir, Log log) throws IOException {
        this.wildflyDir = wildflyDir;
        this.modulesDir = wildflyDir.resolve("modules").resolve("system").resolve("layers").resolve("base");
        this.overlays = this.modulesDir.resolve(".overlays");
        this.overlaysFile = this.overlays.resolve(".overlays");
        this.patchesDir = wildflyDir.resolve(".installation").resolve("patches");
        this.log = log;
        this.existingModules = this.captureModules();
    }

    private Log getLog() {
        return this.log;
    }

    private Set<Path> captureModules() throws IOException {
        final HashSet<Path> existingModules = new HashSet<Path>();
        Files.walkFileTree(this.modulesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path t, BasicFileAttributes bfa) throws IOException {
                if (t.getFileName().toString().equals("module.xml")) {
                    existingModules.add(LegacyPatchCleaner.this.modulesDir.relativize(t).getParent());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return existingModules;
    }

    public void clean() throws Exception {
        this.cleanupModules();
    }

    private void cleanupModules() throws Exception {
        String[] children;
        this.getLog().info((CharSequence)"Legacy patch cleanup enabled, checking for unused resources...");
        if (Files.notExists(this.overlays, new LinkOption[0])) {
            return;
        }
        if (Files.notExists(this.overlaysFile, new LinkOption[0])) {
            return;
        }
        HashMap<String, Map<Path, Path>> newPatchedModules = new HashMap<String, Map<Path, Path>>();
        HashMap<Path, Path> existingPatchedModules = new HashMap<Path, Path>();
        final HashSet<Path> overlayRoots = new HashSet<Path>();
        List<String> lines = Files.readAllLines(this.overlaysFile);
        for (String line : lines) {
            final Path dir = this.overlays.resolve(line);
            overlayRoots.add(dir);
            if (!Files.exists(dir, new LinkOption[0])) continue;
            final HashSet hashSet = new HashSet();
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path t, BasicFileAttributes bfa) throws IOException {
                    if (t.getFileName().toString().equals("module.xml")) {
                        hashSet.add(dir.relativize(t).getParent());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Path p : hashSet) {
                if (!this.existingModules.contains(p)) {
                    HashMap<Path, Path> location = new HashMap<Path, Path>();
                    location.put(p, dir.resolve(p).resolve("module.xml"));
                    newPatchedModules.put(p.getParent().toString().replace(File.separator, "."), location);
                    continue;
                }
                existingPatchedModules.put(p, dir.resolve(p).resolve("module.xml"));
            }
        }
        HashMap<Path, Path> rootReferences = new HashMap<Path, Path>();
        rootReferences.putAll(existingPatchedModules);
        Set<String> newReferencedModules = null;
        do {
            newReferencedModules = this.getNewRequiredDependencies(rootReferences, newPatchedModules);
            rootReferences = new HashMap();
            for (String string : newReferencedModules) {
                Map loc = (Map)newPatchedModules.remove(string);
                rootReferences.putAll(loc);
            }
        } while (!rootReferences.isEmpty());
        if (!newPatchedModules.isEmpty()) {
            this.getLog().info((CharSequence)"Deleting module directories introduced by patch that are unused:");
            Iterator remainingModules = new HashSet();
            for (String module : newPatchedModules.keySet()) {
                Map location = (Map)newPatchedModules.get(module);
                Path absoluteLocation = ((Path)location.values().iterator().next()).getParent();
                remainingModules.add((Path)absoluteLocation);
                this.getLog().info((CharSequence)(" * " + this.wildflyDir.relativize(absoluteLocation)));
                IoUtils.recursiveDelete((Path)absoluteLocation);
            }
            Iterator iterator = remainingModules.iterator();
            while (iterator.hasNext()) {
                Path p = (Path)iterator.next();
                while (!overlayRoots.contains(p) && (children = (p = p.getParent()).toFile().list()) != null && children.length == 0) {
                    this.getLog().info((CharSequence)(" * " + this.wildflyDir.relativize(p)));
                    Files.delete(p);
                }
            }
        }
        if (!existingPatchedModules.isEmpty()) {
            Path abs;
            this.getLog().info((CharSequence)"Deleting patched module directories original locations:");
            for (Path path : existingPatchedModules.keySet()) {
                abs = this.modulesDir.resolve(path);
                this.getLog().info((CharSequence)(" * " + this.wildflyDir.relativize(abs)));
                IoUtils.recursiveDelete((Path)abs);
            }
            for (Path path : existingPatchedModules.keySet()) {
                abs = this.modulesDir.resolve(path);
                while (!abs.equals(this.modulesDir) && (children = (abs = abs.getParent()).toFile().list()) != null && children.length == 0) {
                    this.getLog().info((CharSequence)(" * " + this.wildflyDir.relativize(abs)));
                    Files.delete(abs);
                }
            }
        }
        final HashSet unusedLayers = new HashSet();
        Files.walkFileTree(this.overlays, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path t, BasicFileAttributes bfa) throws IOException {
                if (LegacyPatchCleaner.this.overlays.equals(t)) {
                    return FileVisitResult.CONTINUE;
                }
                if (!overlayRoots.contains(t)) {
                    unusedLayers.add(t);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        if (!unusedLayers.isEmpty()) {
            this.getLog().info((CharSequence)"Deleting unused overlay directories:");
            for (Path unused : unusedLayers) {
                this.getLog().info((CharSequence)(" * " + this.wildflyDir.relativize(unused)));
                IoUtils.recursiveDelete((Path)unused);
            }
        }
        if (Files.exists(this.patchesDir, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deleting " + this.wildflyDir.relativize(this.patchesDir) + " directory"));
            IoUtils.recursiveDelete((Path)this.patchesDir);
        }
    }

    private Set<String> getNewRequiredDependencies(Map<Path, Path> existingPatchedModules, Map<String, Map<Path, Path>> newModules) throws Exception {
        HashSet<String> dependencies = new HashSet<String>();
        for (Path path : existingPatchedModules.values()) {
            FileInputStream fileInputStream = new FileInputStream(path.toFile());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            Element rootElement = document.getDocumentElement();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (!rootElement.getNodeName().equals("module") && !rootElement.getNodeName().equals("module-alias")) continue;
            String moduleName = rootElement.getAttribute("name");
            NodeList lst = (NodeList)xpath.evaluate("/module/dependencies/module", rootElement, XPathConstants.NODESET);
            for (int i = 0; i < lst.getLength(); ++i) {
                boolean optional;
                Element module = (Element)lst.item(i);
                String name = module.getAttribute("name");
                boolean bl = optional = module.hasAttribute("optional") && "true".equals(module.getAttribute("optional"));
                if (!newModules.containsKey(name) || optional) continue;
                this.getLog().info((CharSequence)("New module " + name + " is a new dependency of " + moduleName + " patched module, will be not deleted."));
                dependencies.add(name);
            }
        }
        return dependencies;
    }
}

