/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractDevBootableJarMojo;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;
import org.wildfly.plugins.bootablejar.maven.goals.DevWatchContext;

@Mojo(name="dev-watch", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public final class DevWatchBootableJarMojo
extends AbstractDevBootableJarMojo {
    private static final String MANAGEMENT_LAYER = "management";
    private static final Set<String> POST_COMPILE_PHASES = new HashSet<String>(Arrays.asList("compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy"));
    private static final String ORG_APACHE_MAVEN_PLUGINS = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String MAVEN_COMPILER_GOAL = "compile";
    private static final String MAVEN_WAR_PLUGIN = "maven-war-plugin";
    private static final String MAVEN_EXPLODED_GOAL = "exploded";
    private static final String MAVEN_JAR_PLUGIN = "maven-jar-plugin";
    private static final String MAVEN_EJB_PLUGIN = "maven-ejb-plugin";
    private static final String MAVEN_JAR_GOAL = "jar";
    private static final String MAVEN_EJB_GOAL = "ejb";
    private static final String MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String MAVEN_RESOURCES_GOAL = "resources";
    private static final String REBUILD_MARKER = "wildfly.bootable.jar.rebuild";
    private static final String MAVEN_WILDFLY_JAR_PLUGINS = "org.wildfly.plugins";
    private static final String MAVEN_WILDFLY_JAR_PLUGIN = "wildfly-jar-maven-plugin";
    private static final String WATCH_GOAL = "dev-watch";
    private static final boolean IS_WINDOWS;
    private static final String DEBUG_AGENT_OPTION = "-agentlib:jdwp=";
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="localhost", property="wildfly.hostname")
    private String hostname;
    @Parameter(defaultValue="9990", property="wildfly.port")
    private int port;
    @Parameter(property="wildfly.timeout", defaultValue="60")
    protected int timeout;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="false", property="wildfly.bootable.debug")
    private boolean debug;
    @Parameter(alias="debug-port", defaultValue="8787", property="wildfly.bootable.debug.port")
    private int debugPort;
    @Parameter(alias="debug-suspend", defaultValue="false", property="wildfly.bootable.debug.suspend")
    private boolean debugSuspend;
    @Parameter(defaultValue="false", property="wildfly.bootable.remote")
    private boolean remote;
    @Parameter(property="wildfly.bootable.remote.username")
    private String username;
    @Parameter(property="wildfly.bootable.remote.password")
    private String password;
    @Parameter(defaultValue="remote+http", property="wildfly.bootable.remote.protocol")
    private String protocol;
    private Process process;
    private Path currentServerDir;
    private DeploymentController deploymentController;
    static final String TEST_PROPERTY_EXIT = "dev-watch.test.exit.on.file";

    @Override
    protected void configureServer() {
        this.getLog().info((CharSequence)"Dev mode, adding layer management to ensure dev mode can be operated");
        this.addExtraLayer(MANAGEMENT_LAYER);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.remote) {
            if (this.skip) {
                this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
                return;
            }
            this.hollowJar = true;
            this.doExecute();
            return;
        }
        super.execute();
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        boolean isRebuild;
        this.deploymentController = this.remote ? new RemoteDeploymentController(this.project.getBuild().getFinalName() + "." + this.project.getPackaging()) : new LocalDeploymentController();
        boolean bl = isRebuild = System.getProperty(REBUILD_MARKER) != null;
        if (isRebuild) {
            return;
        }
        try {
            final WatchService watcher = FileSystems.getDefault().newWatchService();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        watcher.close();
                    }
                    catch (IOException ex) {
                        DevWatchBootableJarMojo.this.getLog().error((CharSequence)("Error closing the watcher " + ex));
                    }
                    DevWatchBootableJarMojo.this.shutdownContainer();
                }
            }));
            ProjectContextImpl projectContext = new ProjectContextImpl(this.project, (Xpp3Dom)this.getPlugin(this.project).getConfiguration(), Paths.get(this.projectBuildDir, new String[0]), this.sourceDir.toPath(), this.contextRoot, this.cliSessions, this.extraServerContentDirs);
            DevWatchContext ctx = new DevWatchContext(projectContext, watcher);
            ctx.build(true);
            if (!this.remote) {
                this.process = Launcher.of((CommandBuilder)this.buildCommandBuilder(false)).inherit().launch();
            }
            this.deploymentController.deploy(ctx.getTargetDirectory());
            this.watch(watcher, ctx);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected BootableJarCommandBuilder buildCommandBuilder(boolean redirect) throws MojoExecutionException {
        BootableJarCommandBuilder builder = super.buildCommandBuilder(redirect);
        if (this.debug) {
            boolean custom = false;
            for (String opt : builder.getJavaOptions()) {
                if (!opt.startsWith(DEBUG_AGENT_OPTION)) continue;
                custom = true;
                break;
            }
            if (!custom) {
                builder.addJavaOption("-agentlib:jdwp=transport=dt_socket,address=" + (Utils.isModularJVM() ? "*:" : "") + this.debugPort + ",server=y,suspend=" + (this.debugSuspend ? "y" : "n"));
            }
        }
        return builder;
    }

    /*
     * Exception decompiling
     */
    private void watch(WatchService watcher, DevWatchContext ctx) throws IOException, MojoExecutionException, InterruptedException, MojoFailureException, ProjectBuildingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void handleAutoCompile(MavenProject project) throws MojoExecutionException {
        if (this.needCompile()) {
            this.triggerCompile(project);
        }
    }

    private boolean needCompile() {
        boolean compileNeeded = true;
        for (String goal : this.session.getGoals()) {
            if (POST_COMPILE_PHASES.contains(goal)) {
                compileNeeded = false;
                break;
            }
            if (!goal.endsWith("wildfly-jar:dev-watch")) continue;
            break;
        }
        return compileNeeded;
    }

    void triggerCompile(MavenProject project) throws MojoExecutionException {
        String compilerPluginKey = "org.apache.maven.plugins:maven-compiler-plugin";
        Plugin compilerPlugin = project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (compilerPlugin != null) {
            this.executeGoal(project, compilerPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_COMPILER_PLUGIN, MAVEN_COMPILER_GOAL, this.getPluginConfig(compilerPlugin, MAVEN_COMPILER_GOAL));
        }
    }

    void triggerExplodeWar(MavenProject project, Path targetDir) throws MojoExecutionException {
        String warPluginKey = "org.apache.maven.plugins:maven-war-plugin";
        Plugin warPlugin = project.getPlugin("org.apache.maven.plugins:maven-war-plugin");
        if (warPlugin != null) {
            this.executeGoal(project, warPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_WAR_PLUGIN, MAVEN_EXPLODED_GOAL, this.getPluginConfig(warPlugin, targetDir));
        } else {
            this.getLog().warn((CharSequence)"Can't package war application, war plugin not found");
        }
    }

    void triggerJar(MavenProject project) throws MojoExecutionException {
        String ejbPluginKey = "org.apache.maven.plugins:maven-ejb-plugin";
        Plugin ejbPlugin = project.getPlugin("org.apache.maven.plugins:maven-ejb-plugin");
        if (ejbPlugin != null) {
            this.executeGoal(project, ejbPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_EJB_PLUGIN, MAVEN_EJB_GOAL, this.getPluginConfig(ejbPlugin, MAVEN_EJB_GOAL));
        } else {
            String jarPluginKey = "org.apache.maven.plugins:maven-jar-plugin";
            Plugin jarPlugin = project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
            if (jarPlugin != null) {
                this.executeGoal(project, jarPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_JAR_PLUGIN, MAVEN_JAR_GOAL, this.getPluginConfig(jarPlugin, MAVEN_JAR_GOAL));
            } else {
                this.getLog().warn((CharSequence)"Can't package jar application, jar nor ejb plugins found");
            }
        }
    }

    Plugin getPlugin(MavenProject project) {
        String jarPluginKey = "org.wildfly.plugins:wildfly-jar-maven-plugin";
        return project.getPlugin("org.wildfly.plugins:wildfly-jar-maven-plugin");
    }

    MavenProject newProject(Path pomFile) throws ProjectBuildingException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setResolveDependencies(true);
        return this.projectBuilder.build(pomFile.toFile(), (ProjectBuildingRequest)buildingRequest).getProject();
    }

    private DevWatchContext resetWatcher(WatchService watcher, DevWatchContext ctx) throws MojoExecutionException, ProjectBuildingException, IOException {
        MavenProject mavenProject = this.newProject(this.project.getBasedir().toPath().resolve("pom.xml"));
        this.updateSession(mavenProject);
        ctx.cleanup();
        ProjectContextImpl projectContext = new ProjectContextImpl(mavenProject, (Xpp3Dom)this.getPlugin(mavenProject).getConfiguration(), Paths.get(this.projectBuildDir, new String[0]), this.sourceDir.toPath(), this.contextRoot, this.cliSessions, this.extraServerContentDirs);
        return new DevWatchContext(projectContext, watcher);
    }

    private void updateSession(MavenProject newProject) {
        this.session.setCurrentProject(newProject);
        ArrayList<MavenProject> lst = new ArrayList<MavenProject>();
        lst.add(newProject);
        this.session.setAllProjects(lst);
        this.session.setProjects(lst);
        HashMap<CallSite, MavenProject> map = new HashMap<CallSite, MavenProject>();
        map.put((CallSite)((Object)(newProject.getGroupId() + ":" + newProject.getArtifactId() + ":" + newProject.getVersion())), newProject);
        this.session.setProjectMap(map);
    }

    private DevWatchContext triggerRebuildBootableJar(WatchService watcher, DevWatchContext ctx) throws MojoExecutionException, ProjectBuildingException, IOException {
        MavenProject mavenProject = this.newProject(this.project.getBasedir().toPath().resolve("pom.xml"));
        this.updateSession(mavenProject);
        Plugin jarPlugin = this.getPlugin(mavenProject);
        Path updatedSrcDir = this.sourceDir.toPath();
        Path updatedBuildDir = Paths.get(this.projectBuildDir, new String[0]);
        boolean updatedContextRoot = true;
        ArrayList<String> updatedExtras = new ArrayList<String>();
        ArrayList<CliSession> updatedCliSessions = new ArrayList<CliSession>();
        if (jarPlugin != null) {
            String value;
            String value2;
            String value3;
            String value4;
            Xpp3Dom timeout;
            String value5;
            Xpp3Dom port;
            String value6;
            Xpp3Dom hostname;
            String value7;
            Xpp3Dom ctxRoot;
            Xpp3Dom xpp3Dom;
            Xpp3Dom extra;
            String value8;
            Xpp3Dom projectBuildDir;
            String value9;
            Xpp3Dom srcDir;
            Xpp3Dom config = this.getBootableJarPluginConfig(jarPlugin);
            this.executeGoal(mavenProject, jarPlugin, MAVEN_WILDFLY_JAR_PLUGINS, MAVEN_WILDFLY_JAR_PLUGIN, WATCH_GOAL, config);
            Xpp3Dom jvmArguments = config.getChild("jvmArguments");
            this.jvmArguments.clear();
            if (jvmArguments != null) {
                if (jvmArguments.getChildren() != null && jvmArguments.getChildren().length != 0) {
                    for (Xpp3Dom child : jvmArguments.getChildren()) {
                        this.jvmArguments.add(child.getValue());
                    }
                } else {
                    String value10 = this.resolve(jvmArguments.getValue());
                    if (value10 != null) {
                        this.jvmArguments.addAll(Utils.splitArguments(value10));
                    }
                }
            }
            Xpp3Dom serverArguments = config.getChild("arguments");
            this.arguments.clear();
            if (serverArguments != null) {
                if (serverArguments.getChildren() != null && serverArguments.getChildren().length != 0) {
                    for (Xpp3Dom xpp3Dom2 : serverArguments.getChildren()) {
                        this.arguments.add(xpp3Dom2.getValue());
                    }
                } else {
                    String value11 = this.resolve(serverArguments.getValue());
                    if (value11 != null) {
                        this.arguments.addAll(Utils.splitArguments(value11));
                    }
                }
            }
            if ((srcDir = config.getChild("sourceDir")) != null && (value9 = this.resolve(srcDir.getValue())) != null) {
                updatedSrcDir = Paths.get(value9, new String[0]);
            }
            if ((projectBuildDir = config.getChild("projectBuildDir")) != null && (value8 = this.resolve(projectBuildDir.getValue())) != null) {
                updatedBuildDir = Paths.get(value8, new String[0]);
            }
            if ((extra = config.getChild("extraServerContentDirs")) != null) {
                if (extra.getChildren() != null && extra.getChildren().length != 0) {
                    for (Xpp3Dom child : extra.getChildren()) {
                        updatedExtras.add(child.getValue());
                    }
                } else {
                    String string = this.resolve(extra.getValue());
                    if (string != null) {
                        updatedExtras.addAll(Utils.splitArguments(string));
                    }
                }
            }
            if ((xpp3Dom = config.getChild("cliSessions")) != null) {
                for (Xpp3Dom child : xpp3Dom.getChildren()) {
                    Xpp3Dom scripts;
                    CliSession session = new CliSession();
                    Xpp3Dom props = child.getChild("properties-file");
                    if (props == null) {
                        props = child.getChild("propertiesFile");
                    }
                    if (props != null) {
                        session.setPropertiesFile(props.getValue());
                    }
                    if ((scripts = child.getChild("script-files")) == null) {
                        scripts = child.getChild("scriptFiles");
                    }
                    if (scripts != null) {
                        ArrayList<String> lst = new ArrayList<String>();
                        for (Xpp3Dom script : scripts.getChildren()) {
                            lst.add(script.getValue());
                        }
                        session.setScriptFiles(lst);
                    }
                    updatedCliSessions.add(session);
                }
            }
            if ((ctxRoot = config.getChild("contextRoot")) != null && (value7 = this.resolve(ctxRoot.getValue())) != null) {
                updatedContextRoot = Boolean.valueOf(value7);
            }
            if ((hostname = config.getChild("hostname")) != null && (value6 = this.resolve(hostname.getValue())) != null) {
                this.hostname = value6;
            }
            if ((port = config.getChild("port")) != null && (value5 = this.resolve(port.getValue())) != null) {
                this.port = Integer.parseInt(value5);
            }
            if ((timeout = config.getChild("timeout")) != null && (value4 = this.resolve(timeout.getValue())) != null) {
                this.timeout = Integer.parseInt(value4);
            }
            Xpp3Dom debug = config.getChild("debug");
            this.debug = false;
            if (debug != null && (value3 = this.resolve(debug.getValue())) != null) {
                this.debug = Boolean.parseBoolean(value3);
            }
            Xpp3Dom debugPort = config.getChild("debugPort");
            this.debugPort = 8787;
            if (debugPort != null && (value2 = this.resolve(debugPort.getValue())) != null) {
                this.debugPort = Integer.parseInt(value2);
            }
            Xpp3Dom debugSuspend = config.getChild("debugSuspend");
            this.debugSuspend = false;
            if (debugSuspend != null && (value = this.resolve(debugSuspend.getValue())) != null) {
                this.debugSuspend = Boolean.parseBoolean(value);
            }
        }
        ctx.cleanup();
        ProjectContextImpl projectContext = new ProjectContextImpl(mavenProject, (Xpp3Dom)this.getPlugin(mavenProject).getConfiguration(), updatedBuildDir, updatedSrcDir, updatedContextRoot, updatedCliSessions, updatedExtras);
        return new DevWatchContext(projectContext, watcher);
    }

    private String resolve(String value) {
        if (value != null && value.startsWith("${")) {
            String systemProp = value.substring(2, value.length() - 1);
            value = System.getProperty(systemProp);
        }
        return value;
    }

    private void executeGoal(MavenProject project, Plugin plugin, String groupId, String artifactId, String goal, Xpp3Dom config) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)plugin.getVersion()), (List)plugin.getDependencies()), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    void triggerResources(MavenProject project) throws MojoExecutionException {
        List resources = project.getResources();
        if (resources.isEmpty()) {
            return;
        }
        Plugin resourcesPlugin = project.getPlugin("org.apache.maven.plugins:maven-resources-plugin");
        if (resourcesPlugin == null) {
            return;
        }
        this.executeGoal(project, resourcesPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_RESOURCES_PLUGIN, MAVEN_RESOURCES_GOAL, this.getPluginConfig(resourcesPlugin, MAVEN_RESOURCES_GOAL));
    }

    void cleanClasses(MavenProject project) throws MojoExecutionException {
        Path buildDir = Paths.get(this.projectBuildDir, new String[0]);
        IoUtils.recursiveDelete((Path)Paths.get(project.getBuild().getOutputDirectory(), new String[0]));
        String compilerPluginKey = "org.apache.maven.plugins:maven-compiler-plugin";
        Plugin compilerPlugin = project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (compilerPlugin != null) {
            Path p;
            Xpp3Dom config = this.getPluginConfig(compilerPlugin, MAVEN_COMPILER_GOAL);
            Xpp3Dom genSources = config.getChild("generatedSourcesDirectory");
            if (genSources == null) {
                p = buildDir.resolve("generated-sources").resolve("annotations");
            } else {
                String path = genSources.getValue();
                p = Paths.get(path, new String[0]);
            }
            IoUtils.recursiveDelete((Path)p);
        }
    }

    private Xpp3Dom getPluginConfig(Plugin plugin, Path target) {
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
        if (pluginConfiguration != null) {
            for (Xpp3Dom child : pluginConfiguration.getChildren()) {
                if (child.getName().startsWith("test") || child.getName().startsWith("failOnMissingWebXml")) continue;
                configuration.addChild(child);
            }
        }
        MojoExecutor.Element e = new MojoExecutor.Element("webappDirectory", target.toAbsolutePath().toString(), new MojoExecutor.Element[0]);
        configuration.addChild(e.toDom());
        return configuration;
    }

    private Xpp3Dom getBootableJarPluginConfig(Plugin plugin) {
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
        if (pluginConfiguration != null) {
            for (Xpp3Dom child : pluginConfiguration.getChildren()) {
                String camelName = DevWatchBootableJarMojo.camelize(child.getName());
                Xpp3Dom dom = new Xpp3Dom(camelName);
                if (child.getValue() != null) {
                    dom.setValue(child.getValue());
                }
                for (String string : child.getAttributeNames()) {
                    dom.setAttribute(string, child.getAttribute(string));
                }
                for (String string : child.getChildren()) {
                    dom.addChild((Xpp3Dom)string);
                }
                configuration.addChild(dom);
            }
        }
        return configuration;
    }

    private Xpp3Dom getPluginConfig(Plugin plugin, String goal) throws MojoExecutionException {
        Xpp3Dom mergedConfig = null;
        if (!plugin.getExecutions().isEmpty()) {
            for (PluginExecution exec : plugin.getExecutions()) {
                if (exec.getConfiguration() == null || !exec.getGoals().contains(goal)) continue;
                mergedConfig = mergedConfig == null ? (Xpp3Dom)exec.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)exec.getConfiguration()), (Boolean)true);
            }
        }
        if ((Xpp3Dom)plugin.getConfiguration() != null) {
            mergedConfig = mergedConfig == null ? (Xpp3Dom)plugin.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Boolean)true);
        }
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        if (mergedConfig != null) {
            Set supportedParams = null;
            for (Xpp3Dom child : mergedConfig.getChildren()) {
                if (child.getName().startsWith("test")) continue;
                if (supportedParams == null) {
                    supportedParams = this.getMojoDescriptor(plugin, goal).getParameterMap().keySet();
                }
                if (!supportedParams.contains(child.getName())) continue;
                configuration.addChild(child);
            }
        }
        return configuration;
    }

    private MojoDescriptor getMojoDescriptor(Plugin plugin, String goal) throws MojoExecutionException {
        try {
            return this.pluginManager.getMojoDescriptor(plugin, goal, this.pluginRepos, this.repoSession);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to obtain descriptor for Maven plugin " + plugin.getId() + " goal " + goal, e);
        }
    }

    private ModelControllerClient createClient() throws UnknownHostException {
        if (this.remote && this.username != null && this.password != null) {
            return ModelControllerClient.Factory.create((String)this.protocol, (String)this.hostname, (int)this.port, callbacks -> {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(this.username);
                        this.getLog().debug((CharSequence)("set user " + this.username));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(this.password.toCharArray());
                        StringBuilder builder = new StringBuilder("set password ");
                        for (int i = 0; i < this.password.length(); ++i) {
                            builder.append('*');
                        }
                        this.getLog().debug((CharSequence)builder.toString());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            });
        }
        return ModelControllerClient.Factory.create((String)this.hostname, (int)this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownContainer() {
        if (this.process != null) {
            if (this.process.isAlive()) {
                try (ModelControllerClient client = this.createClient();){
                    ServerHelper.shutdownStandalone((ModelControllerClient)client, (int)this.timeout);
                }
                catch (Throwable ignore) {
                    this.process.destroy();
                }
                try {
                    if (!this.process.waitFor(this.timeout, TimeUnit.SECONDS)) {
                        this.process.destroyForcibly();
                    }
                }
                catch (InterruptedException ex) {
                    this.getLog().error((CharSequence)("Error waiting for process to terminate " + ex));
                }
            }
            this.process = null;
            if (this.currentServerDir != null && Files.exists(this.currentServerDir.resolve("wildfly-cleanup-marker"), new LinkOption[0])) {
                try {
                    int timeout = this.timeout * 1000;
                    while (Files.exists(this.currentServerDir, new LinkOption[0])) {
                        TimeUnit.MILLISECONDS.sleep(500L);
                        if ((timeout -= 500) > 0) continue;
                        this.getLog().warn((CharSequence)String.format("Failed to wait for server directory to be deleted: %s", this.currentServerDir));
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.currentServerDir = null;
                }
            }
        }
    }

    private Path getHomeDirectory(ModelControllerClient client) throws IOException {
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)Operations.createAddress((String[])new String[]{"core-service", "server-environment"}), (String)"home-dir");
        ModelNode result = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            return Paths.get(Operations.readResult((ModelNode)result).asString(), new String[0]);
        }
        this.getLog().warn((CharSequence)String.format("Failed to find home directory: %s", Operations.getFailureDescription((ModelNode)result).asString()));
        return null;
    }

    private static String camelize(String name) {
        StringBuilder buf = null;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if ('-' != name.charAt(i)) continue;
            buf = new StringBuilder(name.substring(0, i));
            break;
        }
        if (buf == null) {
            return name;
        }
        boolean capitalize = true;
        for (int i = buf.length() + 1; i < length; ++i) {
            char c = name.charAt(i);
            if ('-' == c) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                buf.append(Character.toTitleCase(c));
                capitalize = false;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        IS_WINDOWS = os.contains("win");
    }

    private class ProjectContextImpl
    implements DevWatchContext.ProjectContext {
        private final MavenProject currentProject;
        private final Xpp3Dom currentBootableJarConfig;
        private final Path projectBuildDir;
        private final boolean contextRoot;
        private final List<CliSession> cliSessions;
        private final List<String> extraServerContent;
        private final Path sourceDir;

        ProjectContextImpl(MavenProject currentProject, Xpp3Dom currentBootableJarConfig, Path projectBuildDir, Path sourceDir, boolean contextRoot, List<CliSession> cliSessions, List<String> extraServerContent) throws IOException {
            this.currentProject = currentProject;
            this.currentBootableJarConfig = currentBootableJarConfig;
            this.projectBuildDir = projectBuildDir;
            this.sourceDir = sourceDir;
            this.contextRoot = contextRoot;
            this.cliSessions = cliSessions;
            this.extraServerContent = extraServerContent;
        }

        @Override
        public final Path getBaseDir() {
            return this.currentProject.getBasedir().toPath();
        }

        @Override
        public final Path getSourceDir() {
            return this.getBaseDir().resolve("src");
        }

        @Override
        public final Path getJavaDir() {
            return this.sourceDir;
        }

        @Override
        public final Path getProjectBuildDir() {
            return this.projectBuildDir;
        }

        @Override
        public final Path getDeploymentsDir() {
            return DevWatchBootableJarMojo.this.getDeploymentsDir();
        }

        @Override
        public final Set<Path> getResources() {
            HashSet<Path> paths = new HashSet<Path>();
            for (Resource res : this.currentProject.getResources()) {
                paths.add(Paths.get(res.getDirectory(), new String[0]));
            }
            return paths;
        }

        @Override
        public final boolean isContextRoot() {
            return this.contextRoot;
        }

        @Override
        public final String getFinalName() {
            return this.currentProject.getBuild().getFinalName();
        }

        @Override
        public final Path getPomFile() {
            return this.currentProject.getBasedir().toPath().resolve("pom.xml");
        }

        @Override
        public final boolean isPluginConfigUpdated() throws ProjectBuildingException {
            MavenProject newProject = DevWatchBootableJarMojo.this.newProject(this.getPomFile());
            Plugin newPlugin = DevWatchBootableJarMojo.this.getPlugin(newProject);
            return !this.currentBootableJarConfig.equals(newPlugin.getConfiguration());
        }

        @Override
        public final List<CliSession> getCliSessions() {
            return this.cliSessions;
        }

        @Override
        public final List<String> getExtraServerContent() {
            return this.extraServerContent;
        }

        @Override
        public final void debug(String msg) {
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)msg);
        }

        @Override
        public final void info(String msg) {
            DevWatchBootableJarMojo.this.getLog().info((CharSequence)msg);
        }

        @Override
        public final String getPackaging() {
            String packaging = this.currentProject.getPackaging();
            if (DevWatchBootableJarMojo.MAVEN_EJB_GOAL.equals(packaging)) {
                packaging = DevWatchBootableJarMojo.MAVEN_JAR_GOAL;
            }
            return packaging;
        }

        @Override
        public final void cleanup(boolean autoCompile) throws MojoExecutionException {
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"[WATCH] clean-up");
            IoUtils.recursiveDelete((Path)this.getDeploymentsDir());
            boolean cleanClasses = true;
            if (autoCompile) {
                cleanClasses = DevWatchBootableJarMojo.this.needCompile();
            }
            if (cleanClasses) {
                DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"[WATCH] clean-up, classes are cleaned");
                DevWatchBootableJarMojo.this.cleanClasses(this.currentProject);
            } else {
                DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"[WATCH] clean-up, classes are not cleaned, re-using classes from previous phase");
            }
            DevWatchBootableJarMojo.this.triggerResources(this.currentProject);
        }

        @Override
        public final void compile(boolean autoCompile) throws MojoExecutionException {
            if (autoCompile) {
                DevWatchBootableJarMojo.this.handleAutoCompile(this.currentProject);
            } else {
                DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"[WATCH] compile");
                DevWatchBootableJarMojo.this.triggerCompile(this.currentProject);
            }
        }

        @Override
        public final void packageJar(Path targetDir, Path artifactFile) throws IOException, MojoExecutionException {
            DevWatchBootableJarMojo.this.triggerJar(this.currentProject);
            ZipUtils.unzip((Path)artifactFile, (Path)targetDir);
        }

        @Override
        public final void packageWar(Path targetDir) throws MojoExecutionException {
            DevWatchBootableJarMojo.this.triggerExplodeWar(this.currentProject, targetDir);
        }

        @Override
        public void deploy(Path dir) throws Exception {
            DevWatchBootableJarMojo.this.deploymentController.deploy(dir);
        }

        @Override
        public void resources() throws MojoExecutionException {
            DevWatchBootableJarMojo.this.triggerResources(DevWatchBootableJarMojo.this.project);
        }
    }

    private class RemoteDeploymentController
    extends DeploymentController {
        private final String name;

        public RemoteDeploymentController(String name) {
            this.name = name;
        }

        @Override
        public void deploy(Path dir) throws Exception {
            try (ModelControllerClient client = DevWatchBootableJarMojo.this.createClient();){
                DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"Trying to connect to the remote management API");
                ServerHelper.waitForStandalone((ModelControllerClient)client, (long)DevWatchBootableJarMojo.this.timeout);
                DevWatchBootableJarMojo.this.getLog().debug((CharSequence)"Connection to the remote management API effective");
                this.undeploy(client, this.name);
                this.waitRemoved(client, this.name);
                boolean success = this.deploy(client, dir);
                if (success) {
                    this.waitDeploymentUp(client, this.name);
                }
                if (IS_WINDOWS) {
                    DevWatchBootableJarMojo.this.currentServerDir = DevWatchBootableJarMojo.this.getHomeDirectory(client);
                }
            }
        }

        private boolean deploy(ModelControllerClient client, final Path deploymentDir) throws Exception {
            ModelNode composite = Operations.createCompositeOperation();
            final OperationBuilder builder = new OperationBuilder(composite, true);
            ModelNode steps = composite.get("steps");
            ModelNode address = new ModelNode();
            address.add("deployment", this.name);
            ModelNode op = Operations.createOperation((String)"add", (ModelNode)address);
            op.get("runtime-name").set("ROOT.war");
            ModelNode content = op.get("content").get(0);
            content.get("empty").set(true);
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deploy " + this.name));
            steps.add(op);
            final ModelNode addContentOp = Operations.createOperation((String)"add-content", (ModelNode)address);
            Files.walkFileTree(deploymentDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                private int index = 0;
                private int stream = 0;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    builder.addFileAsAttachment(file);
                    DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Sending file " + file + " to " + deploymentDir.relativize(file).toString() + " with index " + this.stream));
                    addContentOp.get("content").get(this.index).get("input-stream-index").set(this.stream++);
                    addContentOp.get("content").get(this.index).get("target-path").set(deploymentDir.relativize(file).toString());
                    ++this.index;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            steps.add(addContentOp);
            steps.add(Operations.createOperation((String)"deploy", (ModelNode)address));
            ModelNode reply = client.execute(builder.build());
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deploy " + this.name + " done " + reply.toJSONString(true)));
            return "success".equals(reply.get("outcome").asString());
        }
    }

    private class LocalDeploymentController
    extends DeploymentController {
        private LocalDeploymentController() {
        }

        @Override
        public void deploy(Path dir) throws Exception {
            if (DevWatchBootableJarMojo.this.process == null) {
                return;
            }
            String name = dir.getFileName().toString();
            try (ModelControllerClient client = DevWatchBootableJarMojo.this.createClient();){
                ServerHelper.waitForStandalone((ModelControllerClient)client, (long)DevWatchBootableJarMojo.this.timeout);
                this.undeploy(client, name);
                this.waitRemoved(client, name);
                boolean success = this.deploy(client, dir);
                if (success) {
                    this.waitDeploymentUp(client, name);
                }
                if (IS_WINDOWS) {
                    DevWatchBootableJarMojo.this.currentServerDir = DevWatchBootableJarMojo.this.getHomeDirectory(client);
                }
            }
        }

        private boolean deploy(ModelControllerClient client, Path dir) throws Exception {
            ModelNode composite = Operations.createCompositeOperation();
            ModelNode steps = composite.get("steps");
            ModelNode address = new ModelNode();
            String name = dir.getFileName().toString();
            address.add("deployment", name);
            ModelNode op = Operations.createOperation((String)"add", (ModelNode)address);
            ModelNode content = op.get("content").get(0);
            content.get("path").set(dir.toAbsolutePath().toString());
            content.get("archive").set(false);
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deploy " + name));
            steps.add(op);
            steps.add(Operations.createOperation((String)"deploy", (ModelNode)address));
            ModelNode reply = client.execute(composite);
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deploy " + name + " done"));
            return "success".equals(reply.get("outcome").asString());
        }
    }

    private abstract class DeploymentController {
        private DeploymentController() {
        }

        abstract void deploy(Path var1) throws Exception;

        protected void waitRemoved(ModelControllerClient client, String name) throws Exception {
            ModelNode address = new ModelNode();
            address.add("deployment", name);
            this.waitStatus(client, "failed", Operations.createOperation((String)"read-resource", (ModelNode)address));
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deployment " + name + " removed"));
        }

        protected void waitDeploymentUp(ModelControllerClient client, String name) throws Exception {
            ModelNode address = new ModelNode();
            address.add("deployment", name);
            ModelNode op = Operations.createOperation((String)"read-attribute", (ModelNode)address);
            op.get("name").set("status");
            ModelNode reply = this.waitStatus(client, "success", op);
            ModelNode result = reply.get("result");
            if (result.isDefined()) {
                String status = result.asString();
                if ("OK".equals(status)) {
                    DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Deployment " + name + " is up"));
                } else {
                    DevWatchBootableJarMojo.this.getLog().warn((CharSequence)("Deployment " + name + " failed, status is " + status));
                }
            } else {
                throw new MojoExecutionException("No status returned for deployment " + name);
            }
        }

        protected ModelNode waitStatus(ModelControllerClient client, String status, ModelNode op) throws Exception {
            int waitTime = 100;
            for (int t = DevWatchBootableJarMojo.this.timeout * 1000; t >= 0; t -= waitTime) {
                ModelNode reply = client.execute(op);
                if (status.equals(reply.get("outcome").asString())) {
                    return reply;
                }
                Thread.sleep(waitTime);
            }
            throw new MojoExecutionException("Timeout waiting for " + op + " to return " + status + " status");
        }

        protected void undeploy(ModelControllerClient client, String name) throws Exception {
            ModelNode composite = Operations.createCompositeOperation();
            ModelNode steps = composite.get("steps");
            ModelNode address = new ModelNode();
            address.add("deployment", name);
            steps.add(Operations.createOperation((String)"undeploy", (ModelNode)address));
            steps.add(Operations.createOperation((String)"remove", (ModelNode)address));
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Undeploy " + name));
            client.execute(composite);
            DevWatchBootableJarMojo.this.getLog().debug((CharSequence)("Undeploy " + name + " done"));
        }
    }
}

