package org.wildfly.bootablejar.runtime._private;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.RuntimeException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.List;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-03-11T16:06:49+0100")
public class BootableJarLogger_$logger extends DelegatingBasicLogger implements BootableJarLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BootableJarLogger_$logger.class.getName();
    public BootableJarLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void shuttingDown() {
        super.log.logf(FQCN, DEBUG, null, shuttingDown$str());
    }
    protected String shuttingDown$str() {
        return "WFLYJAR0001: Shutting down";
    }
    @Override
    public final void serverStopped() {
        super.log.logf(FQCN, DEBUG, null, serverStopped$str());
    }
    protected String serverStopped$str() {
        return "WFLYJAR0002: Server stopped, exiting";
    }
    @Override
    public final void serverNotStopped() {
        super.log.logf(FQCN, DEBUG, null, serverNotStopped$str());
    }
    protected String serverNotStopped$str() {
        return "WFLYJAR0003: Server not yet stopped, waiting";
    }
    @Override
    public final void nullController() {
        super.log.logf(FQCN, DEBUG, null, nullController$str());
    }
    protected String nullController$str() {
        return "WFLYJAR0004: Null controller client, exiting";
    }
    protected String unexpectedExceptionWhileShuttingDown$str() {
        return "WFLYJAR0005: Unexpected exception while shutting down server";
    }
    @Override
    public final RuntimeException unexpectedExceptionWhileShuttingDown(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unexpectedExceptionWhileShuttingDown$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void installDeployment(final Path dep) {
        super.log.logf(FQCN, INFO, null, installDeployment$str(), dep);
    }
    protected String installDeployment$str() {
        return "WFLYJAR0006: Installed %s in server deployments";
    }
    @Override
    public final void advertiseInstall(final Path home, final long duration) {
        super.log.logf(FQCN, INFO, null, advertiseInstall$str(), home, duration);
    }
    protected String advertiseInstall$str() {
        return "WFLYJAR0007: Installed server and application in %s, took %sms";
    }
    @Override
    public final void advertiseOptions(final List<String> options) {
        super.log.logf(FQCN, INFO, null, advertiseOptions$str(), options);
    }
    protected String advertiseOptions$str() {
        return "WFLYJAR0008: Server options: %s";
    }
    @Override
    public final void deletingHome(final Path dep) {
        super.log.logf(FQCN, DEBUG, null, deletingHome$str(), dep);
    }
    protected String deletingHome$str() {
        return "WFLYJAR0009: Deleting %s dir";
    }
    protected String argPublicBindAddress$str() {
        return "Set system property jboss.bind.address to the given value";
    }
    @Override
    public final String argPublicBindAddress() {
        return String.format(getLoggingLocale(), argPublicBindAddress$str());
    }
    protected String argInterfaceBindAddress$str() {
        return "Set system property jboss.bind.address.<interface> to the given value";
    }
    @Override
    public final String argInterfaceBindAddress() {
        return String.format(getLoggingLocale(), argInterfaceBindAddress$str());
    }
    protected String argSystem$str() {
        return "Set a system property";
    }
    @Override
    public final String argSystem() {
        return String.format(getLoggingLocale(), argSystem$str());
    }
    protected String argHelp$str() {
        return "Display this message and exit";
    }
    @Override
    public final String argHelp() {
        return String.format(getLoggingLocale(), argHelp$str());
    }
    protected String argProperties$str() {
        return "Load system properties from the given url";
    }
    @Override
    public final String argProperties() {
        return String.format(getLoggingLocale(), argProperties$str());
    }
    protected String argDefaultMulticastAddress$str() {
        return "Set system property jboss.default.multicast.address to the given value";
    }
    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(getLoggingLocale(), argDefaultMulticastAddress$str());
    }
    protected String argVersion$str() {
        return "Print version and exit";
    }
    @Override
    public final String argVersion() {
        return String.format(getLoggingLocale(), argVersion$str());
    }
    protected String argSecurityProperty$str() {
        return "Set a security property";
    }
    @Override
    public final String argSecurityProperty() {
        return String.format(getLoggingLocale(), argSecurityProperty$str());
    }
    protected String argDeployment$str() {
        return "Path to deployment artifact (war,jar,ear or exploded deployment dir) to deploy in hollow jar";
    }
    @Override
    public final String argDeployment() {
        return String.format(getLoggingLocale(), argDeployment$str());
    }
    protected String argInstallation$str() {
        return "Path to directory in which the server is installed. By default the server is installed in TEMP directory.";
    }
    @Override
    public final String argInstallation() {
        return String.format(getLoggingLocale(), argInstallation$str());
    }
}
