/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.bootablejar.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.wildfly.bootablejar.runtime.Arguments;
import org.wildfly.bootablejar.runtime.Main;
import org.wildfly.bootablejar.runtime._private.BootableJarLogger;
import org.wildfly.core.embedded.Configuration;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

class BootableJar {
    static final String[] EXTENDED_SYSTEM_PKGS = new String[]{"org.jboss.logging", "org.jboss.logmanager"};
    private BootableJarLogger log;
    private Path jbossHome;
    private final List<String> startServerArgs = new ArrayList<String>();
    private StandaloneServer server;
    private final Arguments arguments;
    private Process process;
    private boolean isLaunch = Boolean.getBoolean("launch");

    public BootableJar(Arguments arguments) throws Exception {
        this.arguments = arguments;
        this.jbossHome = arguments.installDir() == null ? Files.createTempDirectory("wildfly-bootable-server", new FileAttribute[0]) : arguments.installDir();
        long t = System.currentTimeMillis();
        try (InputStream wf = Main.class.getResourceAsStream("/wildfly.zip");){
            BootableJar.unzip(wf, this.jbossHome.toFile());
        }
        this.addDefaultArguments();
        this.startServerArgs.addAll(arguments.getServerArguments());
        this.startServerArgs.add("--read-only-server-config=standalone.xml");
        this.configureLogging();
        if (arguments.getDeployment() != null) {
            Path deployment = this.jbossHome.resolve("standalone/deployments");
            File[] files = deployment.toFile().listFiles((f, name) -> (name = name.toLowerCase()).endsWith(".war") || name.endsWith(".jar") || name.endsWith(".ear"));
            if (files != null && files.length > 0) {
                throw new Exception("Deployment already exists not an hollow-jar");
            }
            Path target = deployment.resolve(arguments.getDeployment().getFileName());
            if (Files.isDirectory(arguments.getDeployment(), new LinkOption[0])) {
                this.copyDirectory(arguments.getDeployment(), target);
                Path doDeploy = deployment.resolve(arguments.getDeployment().getFileName() + ".dodeploy");
                Files.createFile(doDeploy, new FileAttribute[0]);
            } else {
                Files.copy(arguments.getDeployment(), target, new CopyOption[0]);
            }
            this.log.installDeployment(arguments.getDeployment());
        }
        this.log.advertiseInstall(this.jbossHome, System.currentTimeMillis() - t);
    }

    private void copyDirectory(Path src, Path target) throws IOException {
        Files.walk(src, new FileVisitOption[0]).forEach(file -> {
            try {
                Path targetFile = target.resolve(src.relativize((Path)file));
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (!Files.exists(targetFile, new LinkOption[0])) {
                        Files.createDirectory(targetFile, new FileAttribute[0]);
                    }
                } else {
                    Files.copy(file, targetFile, new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void addDefaultArguments() {
        if (!this.isLaunch) {
            this.startServerArgs.add("-Djava.net.preferIPv4Stack=true");
            this.startServerArgs.add("-Djava.awt.headless=true");
            this.startServerArgs.add("-Djboss.modules.system.pkgs=org.jboss.byteman");
        }
    }

    private void configureLogging() throws IOException {
        if (!this.isLaunch) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            this.configureEmbeddedLogging();
        }
        this.log = BootableJarLogger.ROOT_LOGGER;
    }

    private void configureEmbeddedLogging() throws IOException {
        System.setProperty("org.wildfly.logging.embedded", "false");
        if (!this.arguments.isVersion().booleanValue()) {
            LogContext ctx = this.configureLogContext();
            LogContext.setLogContextSelector(() -> ctx);
        }
    }

    LogContext configureLogContext() throws IOException {
        String baseDir = this.jbossHome + File.separator + "standalone";
        String serverLogDir = System.getProperty("jboss.server.log.dir", null);
        if (serverLogDir == null) {
            serverLogDir = baseDir + File.separator + "log";
            System.setProperty("jboss.server.log.dir", serverLogDir);
        }
        String serverCfgDir = System.getProperty("jboss.server.config.dir", baseDir + File.separator + "configuration");
        LogContext embeddedLogContext = LogContext.create();
        Path bootLog = Paths.get(serverLogDir, new String[0]).resolve("server.log");
        Path loggingProperties = Paths.get(serverCfgDir, new String[0]).resolve(Paths.get("logging.properties", new String[0]));
        if (Files.exists(loggingProperties, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(loggingProperties, new OpenOption[0]);){
                System.setProperty("org.jboss.boot.log.file", bootLog.toAbsolutePath().toString());
                PropertyConfigurator configurator = new PropertyConfigurator(embeddedLogContext);
                configurator.configure(in);
            }
        }
        return embeddedLogContext;
    }

    public void run() throws Exception {
        try {
            if (!this.isLaunch) {
                this.server = this.buildServer(this.startServerArgs);
            } else {
                Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                this.startServerProcess();
            }
        }
        catch (RuntimeException ex) {
            this.cleanup();
            throw ex;
        }
        if (!this.isLaunch) {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            this.server.start();
        }
    }

    private void cleanup() {
        this.log.deletingHome(this.jbossHome);
        BootableJar.deleteDir(this.jbossHome);
    }

    private void startServerProcess() throws IOException, InterruptedException {
        StandaloneCommandBuilder builder = StandaloneCommandBuilder.of(this.jbossHome);
        builder.addServerArguments(this.startServerArgs);
        System.out.println("Launching server: " + builder.build());
        Launcher launcher = Launcher.of(builder);
        this.process = launcher.redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).addEnvironmentVariables(System.getenv()).launch();
        this.process.waitFor();
    }

    private StandaloneServer buildServer(List<String> args) throws IOException {
        Configuration.Builder builder = Configuration.Builder.of(this.jbossHome);
        boolean b = Boolean.getBoolean("disable.ext.packages");
        if (!b) {
            builder.addSystemPackages(EXTENDED_SYSTEM_PKGS);
        }
        for (String a : args) {
            builder.addCommandArgument(a);
        }
        this.log.advertiseOptions(args);
        StandaloneServer serv = EmbeddedProcessFactory.createStandaloneServer(builder.build());
        return serv;
    }

    private static void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void unzip(InputStream wf, File dir) throws Exception {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(wf);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(dir, fileName);
                if (fileName.endsWith("/")) {
                    newFile.mkdirs();
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                    continue;
                }
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void shutdown() {
        try {
            ModelNode mn = new ModelNode();
            mn.get("address");
            mn.get("operation").set("read-attribute");
            mn.get("name").set("server-state");
            int i = 0;
            while (i < 10) {
                try {
                    ModelControllerClient client = this.server.getModelControllerClient();
                    if (client == null) {
                        this.log.nullController();
                        return;
                    }
                    ModelNode ret = client.execute(mn);
                    if (ret.hasDefined("result")) {
                        String val = ret.get("result").asString();
                        if ("stopped".equals(val)) {
                            this.log.serverStopped();
                            return;
                        }
                        this.log.serverNotStopped();
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    this.log.unexpectedExceptionWhileShuttingDown(ex);
                }
                ++i;
            }
            return;
        }
        finally {
            this.cleanup();
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            BootableJar.this.log.shuttingDown();
            if (!BootableJar.this.isLaunch) {
                BootableJar.this.shutdown();
            } else {
                if (BootableJar.this.process.isAlive()) {
                    BootableJar.this.process.destroy();
                }
                BootableJar.this.cleanup();
            }
        }
    }
}

