/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.bootablejar.runtime._private;

import java.nio.file.Path;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYJAR", length=4)
public interface BootableJarLogger
extends BasicLogger {
    public static final BootableJarLogger ROOT_LOGGER = Logger.getMessageLogger(BootableJarLogger.class, "org.wildfly.jar");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1, value="Shutting down")
    public void shuttingDown();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="Server stopped, exiting")
    public void serverStopped();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="Server not yet stopped, waiting")
    public void serverNotStopped();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Null controller client, exiting")
    public void nullController();

    @Message(id=5, value="Unexpected exception while shutting down server")
    public RuntimeException unexpectedExceptionWhileShuttingDown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Installed %s in server deployments")
    public void installDeployment(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Installed server and application in %s, took %sms")
    public void advertiseInstall(Path var1, long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Server options: %s")
    public void advertiseOptions(List<String> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="Deleting %s dir")
    public void deletingHome(Path var1);

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Set a security property")
    public String argSecurityProperty();

    @Message(id=0, value="Path to deployment artifact (war,jar,ear or exploded deployment dir) to deploy in hollow jar")
    public String argDeployment();

    @Message(id=0, value="Path to directory in which the server is installed. By default the server is installed in TEMP directory.")
    public String argInstallation();
}

