/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.bootablejar.runtime;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Arguments {
    private Boolean isHelp;
    private Boolean isVersion;
    private final List<String> serverArguments = new ArrayList<String>();
    private Path deployment;
    private Path installDir;

    private Arguments() {
    }

    public static Arguments parseArguments(String[] args) throws Exception {
        Objects.requireNonNull(args);
        Arguments arguments = new Arguments();
        arguments.handleArguments(args);
        return arguments;
    }

    private void handleArguments(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.startsWith("--deployment")) {
                this.deployment = this.checkPath(Arguments.getValue(a));
                continue;
            }
            if (a.startsWith("-b")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--properties".equals(a)) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-S")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-D")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("--start-mode")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-u")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--version".equals(a)) {
                this.isVersion = true;
                this.serverArguments.add(a);
                continue;
            }
            if ("--help".equals(a)) {
                this.isHelp = true;
                continue;
            }
            if (a.startsWith("--install-dir")) {
                this.installDir = Paths.get(Arguments.getValue(a), new String[0]);
                continue;
            }
            throw new Exception("Unknown argument " + a);
        }
    }

    private Path checkPath(String path) {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new RuntimeException("File " + path + " doesn't exist");
        }
        return filePath;
    }

    private static String getValue(String arg) {
        int sep = arg.indexOf("=");
        if (sep == -1 || sep == arg.length() - 1) {
            throw new RuntimeException("Invalid argument " + arg + ", no value provided");
        }
        return arg.substring(sep + 1);
    }

    public Boolean isHelp() {
        return this.isHelp == null ? false : this.isHelp;
    }

    public Boolean isVersion() {
        return this.isVersion == null ? false : this.isVersion;
    }

    public Path installDir() {
        return this.installDir;
    }

    public List<String> getServerArguments() {
        return Collections.unmodifiableList(this.serverArguments);
    }

    public Path getDeployment() {
        return this.deployment;
    }
}

