/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests.runner;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ServiceLoader;
import javax.inject.Inject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.server.TestServer;

public class WildFlyTestRunner
extends BlockJUnit4ClassRunner {
    private static final TestServer server;

    public WildFlyTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Object createTest() throws Exception {
        Object res = super.createTest();
        this.doInject(this.getTestClass().getJavaClass(), res);
        return res;
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                super.testRunFinished(result);
                server.stop();
            }
        });
        server.start();
        super.run(notifier);
    }

    private void doInject(Class<?> clazz, Object instance) {
        try {
            for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (instance == null || Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Inject.class)) continue;
                    field.setAccessible(true);
                    if (field.getType() == ModelControllerClient.class) {
                        field.set(instance, server.getClient());
                        continue;
                    }
                    if (TestServer.class.isAssignableFrom(field.getType())) {
                        field.set(instance, server);
                        continue;
                    }
                    if (!DeploymentManager.class.isAssignableFrom(field.getType())) continue;
                    field.set(instance, server.getDeploymentManager());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to inject", e);
        }
    }

    static {
        ServiceLoader<TestServer> loader = ServiceLoader.load(TestServer.class);
        if (!loader.iterator().hasNext()) {
            throw new RuntimeException("No server implementation found");
        }
        server = loader.iterator().next();
    }
}

