/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.common.ClientCallbackHandler;
import org.wildfly.plugin.common.ConnectionInfo;
import org.wildfly.plugin.common.IoUtils;
import org.wildfly.plugin.common.ServerOperations;

public abstract class AbstractServerConnection
extends AbstractMojo
implements ConnectionInfo,
Closeable {
    public static final String DEBUG_MESSAGE_NO_CREDS = "No username and password in settings.xml file - falling back to CLI entry";
    public static final String DEBUG_MESSAGE_NO_ID = "No <id> element was found in the POM - Getting credentials from CLI entry";
    public static final String DEBUG_MESSAGE_NO_SERVER_SECTION = "No <server> section was found for the specified id";
    public static final String DEBUG_MESSAGE_NO_SETTINGS_FILE = "No settings.xml file was found in this Mojo's execution context";
    public static final String DEBUG_MESSAGE_POM_HAS_CREDS = "Getting credentials from the POM";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_CREDS = "Found username and password in the settings.xml file";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_ID = "Found the server's id in the settings.xml file";
    protected static final Object CLIENT_LOCK = new Object();
    private volatile InetAddress address = null;
    private volatile CallbackHandler handler;
    @Parameter(defaultValue="localhost", property="wildfly.hostname")
    private String hostname;
    @Parameter(defaultValue="9990", property="wildfly.port")
    private int port;
    @Parameter(property="wildfly.id")
    private String id;
    @Parameter(property="settings", readonly=true, required=true, defaultValue="${settings}")
    private Settings settings;
    @Parameter(property="wildfly.username")
    private String username;
    @Parameter(property="wildfly.password")
    private String password;
    private ModelControllerClient client;

    public final String hostname() {
        return this.hostname;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDomainServer() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            return this.isDomainServer(this.getClient());
        }
    }

    public abstract String goal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModelControllerClient getClient() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            ModelControllerClient result = this.client;
            if (result == null && this.isDomainServer(result = (this.client = ModelControllerClient.Factory.create((InetAddress)this.getHostAddress(), (int)this.getPort(), (CallbackHandler)this.getCallbackHandler())))) {
                result = this.client = DomainClient.Factory.create((ModelControllerClient)result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = CLIENT_LOCK;
        synchronized (object) {
            IoUtils.safeClose((Closeable)this.client);
            this.client = null;
        }
    }

    @Override
    public final synchronized InetAddress getHostAddress() {
        InetAddress result = this.address;
        if (result == null) {
            try {
                result = this.address = InetAddress.getByName(this.hostname());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host name '%s' is invalid.", this.hostname), e);
            }
        }
        return result;
    }

    @Override
    public final synchronized CallbackHandler getCallbackHandler() {
        CallbackHandler result = this.handler;
        if (result == null) {
            if (this.username == null && this.password == null) {
                if (this.id != null) {
                    this.getCredentialsFromSettings();
                } else {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_ID);
                }
            } else {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_POM_HAS_CREDS);
            }
            result = this.handler = new ClientCallbackHandler(this.username, this.password);
        }
        return result;
    }

    private void getCredentialsFromSettings() {
        if (this.settings != null) {
            Server server = this.settings.getServer(this.id);
            if (server != null) {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_ID);
                this.password = server.getPassword();
                this.username = server.getUsername();
                if (this.username != null && this.password != null) {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_CREDS);
                } else {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_CREDS);
                }
            } else {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_SERVER_SECTION);
            }
        } else {
            this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_SETTINGS_FILE);
        }
    }

    private boolean isDomainServer(ModelControllerClient client) {
        boolean result = false;
        ModelNode op = ServerOperations.createReadAttributeOperation("launch-type");
        try {
            ModelNode opResult = client.execute(op);
            if (ServerOperations.isSuccessfulOutcome((ModelNode)opResult)) {
                result = "DOMAIN".equals(ServerOperations.readResultAsString(opResult));
            }
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Throwable)e);
            }
            throw new IllegalStateException(String.format("I/O Error could not execute operation '%s'", op), e);
        }
        return result;
    }
}

