/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.util.List;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ServerOperations
extends Operations {
    public static final String ENABLE = "enable";
    public static final String LAUNCH_TYPE = "launch-type";
    public static final String PROFILE = "profile";
    public static final String READ_CHILDREN_NAMES = "read-children-names";
    public static final String READ_RESOURCE = "read-resource";
    public static final String RELOAD = "reload";
    public static final String SERVER_STATE = "server-state";
    public static final String SHUTDOWN = "shutdown";

    public static String getFailureDescriptionAsString(ModelNode result) {
        if (ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
            return "";
        }
        String msg = result.hasDefined("failure-description") ? (result.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", result.get("operation"), result.get("address"), result.get("failure-description")) : String.format("Operation failed: %s", result.get("failure-description"))) : String.format("An unexpected response was found checking the deployment. Result: %s", result);
        return msg;
    }

    public static ModelNode createListDeploymentsOperation() {
        ModelNode op = ServerOperations.createOperation((String)READ_CHILDREN_NAMES);
        op.get("child-type").set("deployment");
        return op;
    }

    public static ModelNode createRemoveOperation(ModelNode address, boolean recursive) {
        ModelNode op = ServerOperations.createRemoveOperation((ModelNode)address);
        op.get("recursive").set(recursive);
        return op;
    }

    public static ModelNode createReadAttributeOperation(String attributeName) {
        return ServerOperations.createReadAttributeOperation((ModelNode)new ModelNode().setEmptyList(), (String)attributeName);
    }

    public static ModelNode createAddress(String key, String name) {
        ModelNode address = new ModelNode().setEmptyList();
        address.add(key, name);
        return address;
    }

    public static ModelNode createOperation(String operation, ModelNode address, boolean recursive) {
        ModelNode op = ServerOperations.createOperation((String)operation, (ModelNode)address);
        op.get("recursive").set(recursive);
        return op;
    }

    public static Property getChildAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        return (Property)addressParts.get(addressParts.size() - 1);
    }

    public static ModelNode getParentAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        ModelNode result = new ModelNode();
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        for (int i = 0; i < addressParts.size() - 1; ++i) {
            Property property = (Property)addressParts.get(i);
            result.add(property.getName(), property.getValue());
        }
        return result;
    }

    public static String readResultAsString(ModelNode result) {
        return result.hasDefined("result") ? result.get("result").asString() : "";
    }
}

