/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import org.wildfly.plugin.server.Server;

final class SecurityActions {
    SecurityActions() {
    }

    static void registerShutdown(final Server server) {
        Thread hook = new Thread(new Runnable(){

            @Override
            public void run() {
                server.stop();
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        hook.setDaemon(true);
        SecurityActions.addShutdownHook(hook);
    }

    static void addShutdownHook(final Thread hook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }

    static String getEnvironmentVariable(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getenv(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }
}

