/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(alias="execute-commands")
    private Commands executeCommands;

    @Override
    public String goal() {
        return "execute-commands";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping commands execution");
            return;
        }
        this.getLog().debug((CharSequence)"Executing commands");
        Object object = CLIENT_LOCK;
        synchronized (object) {
            ModelControllerClient client = this.getClient();
            try {
                this.executeCommands.execute(client);
            }
            catch (IOException e) {
                throw new MojoFailureException("Could not execute commands.", (Throwable)e);
            }
            finally {
                this.close();
            }
        }
    }
}

