/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.standalone;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.common.DeploymentExecutionException;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.DeploymentInspector;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.MatchPatternStrategy;

public class StandaloneDeployment
implements Deployment {
    private final File content;
    private final ModelControllerClient client;
    private final String name;
    private final Deployment.Type type;
    private final String matchPattern;
    private final MatchPatternStrategy matchPatternStrategy;

    public StandaloneDeployment(ModelControllerClient client, File content, String name, Deployment.Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        this.content = content;
        this.client = client;
        this.name = name == null ? content.getName() : name;
        this.type = type;
        this.matchPattern = matchPattern;
        this.matchPatternStrategy = matchPatternStrategy;
    }

    public static StandaloneDeployment create(ModelControllerClient client, File content, String name, Deployment.Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        return new StandaloneDeployment(client, content, name, type, matchPattern, matchPatternStrategy);
    }

    private void validateExistingDeployments(List<String> existingDeployments) throws DeploymentFailureException {
        if (this.matchPattern == null) {
            return;
        }
        if (this.matchPatternStrategy == MatchPatternStrategy.FAIL && existingDeployments.size() > 1) {
            throw new DeploymentFailureException(String.format("Deployment failed, found %d deployed artifacts for pattern '%s' (%s)", existingDeployments.size(), this.matchPattern, existingDeployments));
        }
    }

    @Override
    public Deployment.Status execute() throws DeploymentExecutionException, DeploymentFailureException {
        try {
            Operation operation;
            List<String> existingDeployments = DeploymentInspector.getDeployments(this.client, this.name, this.matchPattern);
            switch (this.type) {
                case DEPLOY: {
                    operation = StandaloneDeployment.createDeployOperation(this.content.toPath(), this.name, null);
                    break;
                }
                case FORCE_DEPLOY: {
                    if (existingDeployments.contains(this.name)) {
                        operation = StandaloneDeployment.createReplaceOperation(this.content.toPath(), this.name, null);
                        break;
                    }
                    operation = StandaloneDeployment.createDeployOperation(this.content.toPath(), this.name, null);
                    break;
                }
                case REDEPLOY: {
                    if (!existingDeployments.contains(this.name)) {
                        throw new DeploymentFailureException("Deployment '%s' not found, cannot redeploy", this.name);
                    }
                    operation = StandaloneDeployment.createRedeployOperation(this.name);
                    break;
                }
                case UNDEPLOY: {
                    this.validateExistingDeployments(existingDeployments);
                    operation = StandaloneDeployment.createUndeployOperation(this.matchPatternStrategy, existingDeployments);
                    break;
                }
                case UNDEPLOY_IGNORE_MISSING: {
                    if (existingDeployments.isEmpty()) {
                        operation = null;
                        break;
                    }
                    this.validateExistingDeployments(existingDeployments);
                    operation = StandaloneDeployment.createUndeployOperation(this.matchPatternStrategy, existingDeployments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type: " + (Object)((Object)this.type));
                }
            }
            if (operation == null) {
                return Deployment.Status.SUCCESS;
            }
            ModelNode result = this.client.execute(operation);
            if (ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                return Deployment.Status.SUCCESS;
            }
            throw new DeploymentExecutionException("Deployment failed: %s", ServerOperations.getFailureDescriptionAsString(result));
        }
        catch (DeploymentExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentExecutionException(e, "Error executing %s", new Object[]{this.type});
        }
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private static void addContent(Path deployment, ModelNode op, boolean unmanaged) throws IOException {
        ModelNode contentNode = op.get("content");
        ModelNode contentItem = contentNode.get(0);
        if (unmanaged) {
            contentItem.get("path").set(deployment.toString());
            contentItem.get("archive").set(!Files.isDirectory(deployment, new LinkOption[0]));
        } else {
            contentItem.get("bytes").set(Files.readAllBytes(deployment));
        }
    }

    private static Operation createDeployOperation(Path deployment, String name, String runtimeName) throws IOException {
        ModelNode address = ServerOperations.createAddress("deployment", name);
        ModelNode addOperation = Operations.createAddOperation((ModelNode)address);
        if (runtimeName != null) {
            addOperation.get("runtime-name").set(runtimeName);
        }
        StandaloneDeployment.addContent(deployment, addOperation, false);
        return Operations.CompositeOperationBuilder.create().addStep(addOperation).addStep(Operations.createOperation((String)"deploy", (ModelNode)address)).build();
    }

    private static Operation createReplaceOperation(Path deployment, String name, String runtimeName) throws IOException {
        ModelNode op = Operations.createOperation((String)"full-replace-deployment");
        op.get("name").set(name);
        if (runtimeName != null) {
            op.get("runtime-name").set(runtimeName);
        }
        StandaloneDeployment.addContent(deployment, op, false);
        op.get("enable").set(true);
        return OperationBuilder.create((ModelNode)op).build();
    }

    private static Operation createRedeployOperation(String name) throws IOException {
        return OperationBuilder.create((ModelNode)Operations.createOperation((String)"redeploy", (ModelNode)ServerOperations.createAddress("deployment", name))).build();
    }

    private static Operation createUndeployOperation(MatchPatternStrategy matchPatternStrategy, Collection<String> names) throws IOException {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (String name : names) {
            ModelNode address = ServerOperations.createAddress("deployment", name);
            builder.addStep(Operations.createOperation((String)"undeploy", (ModelNode)address)).addStep(ServerOperations.createRemoveOperation((ModelNode)address));
            if (matchPatternStrategy != MatchPatternStrategy.FIRST) continue;
            break;
        }
        return builder.build();
    }
}

