/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.server.ServerHelper;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class Server {
    private final ScheduledExecutorService timerService;
    private final CommandBuilder commandBuilder;
    private volatile Thread shutdownHook;
    private Process process;

    protected Server(CommandBuilder commandBuilder) {
        this.commandBuilder = commandBuilder;
        this.timerService = Executors.newScheduledThreadPool(1);
    }

    static Server create(CommandBuilder commandBuilder, final ModelControllerClient client) {
        if (commandBuilder instanceof DomainCommandBuilder) {
            return new Server(commandBuilder){
                final DomainClient domainClient;
                final Map<ServerIdentity, ServerStatus> servers;
                volatile boolean isRunning;
                {
                    super(commandBuilder);
                    this.domainClient = DomainClient.Factory.create((ModelControllerClient)client);
                    this.servers = new HashMap<ServerIdentity, ServerStatus>();
                    this.isRunning = false;
                }

                @Override
                protected void stopServer() {
                    ServerHelper.shutdownDomain(this.domainClient, this.servers);
                }

                @Override
                protected boolean waitForStart(long timeout) throws IOException, InterruptedException {
                    return ServerHelper.waitForDomain(((Server)this).process, this.domainClient, this.servers, timeout);
                }

                @Override
                public boolean isRunning() {
                    return this.isRunning;
                }

                @Override
                protected void checkServerState() {
                    this.isRunning = ServerHelper.isDomainRunning(this.domainClient, this.servers);
                }
            };
        }
        return new Server(commandBuilder){
            volatile boolean isRunning;
            {
                super(commandBuilder);
                this.isRunning = false;
            }

            @Override
            protected void stopServer() {
                ServerHelper.shutdownStandalone(client);
            }

            @Override
            protected boolean waitForStart(long timeout) throws IOException, InterruptedException {
                return ServerHelper.waitForStandalone(((Server)this).process, client, timeout);
            }

            @Override
            public boolean isRunning() {
                return this.isRunning;
            }

            @Override
            protected void checkServerState() {
                this.isRunning = ServerHelper.isStandaloneRunning(client);
            }
        };
    }

    public final synchronized void start(long timeout) throws IOException, InterruptedException {
        this.process = Launcher.of((CommandBuilder)this.commandBuilder).inherit().launch();
        this.shutdownHook = (Thread)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return ProcessHelper.addShutdownHook((Process)Server.this.process);
            }
        });
        if (!this.waitForStart(timeout)) {
            try {
                ProcessHelper.destroyProcess((Process)this.process);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException(String.format("Managed server was not started within [%d] s", timeout));
        }
        this.timerService.scheduleWithFixedDelay(new Reaper(), 20L, 10L, TimeUnit.SECONDS);
    }

    public final synchronized void stop() {
        try {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Runtime.getRuntime().removeShutdownHook(Server.this.shutdownHook);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
            try {
                this.timerService.shutdown();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.stopServer();
        }
        finally {
            try {
                ProcessHelper.destroyProcess((Process)this.process);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void stopServer();

    protected abstract boolean waitForStart(long var1) throws IOException, InterruptedException;

    public abstract boolean isRunning();

    protected abstract void checkServerState();

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        @Override
        public void run() {
            Server.this.checkServerState();
            if (!Server.this.isRunning()) {
                Server.this.stop();
            }
        }
    }
}

