/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.ManagementClient;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="execute-commands")
    private Commands executeCommands;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping commands execution");
            return;
        }
        this.getLog().debug((CharSequence)"Executing commands");
        try (ManagementClient client = this.createClient();){
            this.commandExecutor.execute(client, this.jbossHome, this.executeCommands);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not execute commands.", (Exception)e);
        }
    }
}

