/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.DeploymentExecutionException;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.ManagementClient;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.MatchPatternStrategy;
import org.wildfly.plugin.deployment.domain.Domain;
import org.wildfly.plugin.deployment.domain.DomainDeployment;
import org.wildfly.plugin.deployment.standalone.StandaloneDeployment;
import org.wildfly.plugin.server.ServerHelper;

abstract class AbstractDeployment
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private Domain domain;
    @Parameter
    protected String name;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="before-deployment")
    private Commands beforeDeployment;
    @Parameter(alias="after-deployment")
    private Commands afterDeployment;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Inject
    private CommandExecutor commandExecutor;

    AbstractDeployment() {
    }

    protected abstract File file();

    @Override
    public abstract String goal();

    public abstract Deployment.Type getType();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        this.doExecute();
    }

    protected final Deployment.Status executeDeployment(ManagementClient client, Deployment deployment, Path wildflyHome) throws DeploymentExecutionException, DeploymentFailureException, IOException {
        if (this.beforeDeployment != null) {
            this.commandExecutor.execute(client, wildflyHome, this.beforeDeployment);
        }
        this.getLog().debug((CharSequence)"Executing deployment");
        Deployment.Status status = deployment.execute();
        if (this.afterDeployment != null) {
            this.commandExecutor.execute(client, wildflyHome, this.afterDeployment);
        }
        return status;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try (ManagementClient client = this.createClient();){
            void var6_12;
            boolean isDomain = ServerHelper.isDomainServer(client);
            this.validate(client, isDomain);
            String matchPattern = this.getMatchPattern();
            MatchPatternStrategy matchPatternStrategy = this.getMatchPatternStrategy();
            if (isDomain) {
                DomainDeployment domainDeployment = DomainDeployment.create(DomainClient.Factory.create((ModelControllerClient)client), this.domain, this.file(), this.name, this.getType(), matchPattern, matchPatternStrategy);
            } else {
                StandaloneDeployment standaloneDeployment = StandaloneDeployment.create(client, this.file(), this.name, this.getType(), matchPattern, matchPatternStrategy);
            }
            Path wildflyHome = this.jbossHome == null ? null : Paths.get(this.jbossHome, new String[0]);
            switch (this.executeDeployment(client, (Deployment)var6_12, wildflyHome)) {
                case REQUIRES_RESTART: {
                    this.getLog().info((CharSequence)"Server requires a restart");
                    return;
                }
            }
            return;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s on %s. Reason: %s", this.goal(), this.file(), e.getMessage()), e);
        }
    }

    protected String getMatchPattern() {
        return null;
    }

    protected MatchPatternStrategy getMatchPatternStrategy() {
        return null;
    }

    protected void validate(ModelControllerClient client, boolean isDomain) throws DeploymentFailureException {
        if (isDomain) {
            if (this.domain == null || this.domain.getServerGroups().isEmpty()) {
                throw new DeploymentFailureException("Server is running in domain mode, but no server groups have been defined.");
            }
        } else if (this.domain != null && !this.domain.getServerGroups().isEmpty()) {
            throw new DeploymentFailureException("Server is running in standalone mode, but server groups have been defined.");
        }
    }
}

