/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

class Archives {
    Archives() {
    }

    public static void deleteDirectory(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path '%s' is not a directory.", dir));
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void unzip(Path zipFile, Path targetDir) throws IOException {
        Path archive = Archives.getArchive(zipFile);
        try (ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(archive, new OpenOption[0])));){
            ArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                Path extractTarget = targetDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(extractTarget, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(extractTarget.getParent(), new FileAttribute[0]);
                Files.copy((InputStream)in, extractTarget, new CopyOption[0]);
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    private static Path getArchive(Path path) throws IOException {
        Path result;
        block15: {
            String fileName = path.getFileName().toString();
            String loweredFileName = fileName.toLowerCase(Locale.ENGLISH);
            if (loweredFileName.endsWith(".gz")) {
                String tempFileName = fileName.substring(0, loweredFileName.indexOf(".gz"));
                int index = tempFileName.lastIndexOf(46);
                result = index > 0 ? Files.createTempFile(tempFileName.substring(0, index), tempFileName.substring(index, tempFileName.length()), new FileAttribute[0]) : Files.createTempFile(tempFileName.substring(0, index), "", new FileAttribute[0]);
                try (CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                    Files.copy((InputStream)in, result, StandardCopyOption.REPLACE_EXISTING);
                    break block15;
                }
                catch (CompressorException e) {
                    throw new IOException(e);
                }
            }
            result = path;
        }
        return result;
    }
}

