/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.domain;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.DeploymentBuilder;
import org.wildfly.plugin.deployment.domain.Domain;
import org.wildfly.plugin.deployment.domain.DomainDeployment;

public class DomainDeploymentBuilder
extends DeploymentBuilder<DomainDeploymentBuilder> {
    private final Domain domain;

    public DomainDeploymentBuilder(ModelControllerClient client, Domain domain) {
        super(client);
        this.domain = domain;
    }

    @Override
    protected DomainDeploymentBuilder getThis() {
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.domain == null) {
            throw new IllegalStateException("A domain myst be defined for domain deployments");
        }
    }

    @Override
    protected Deployment doBuild() {
        DomainClient domainClient = this.client instanceof DomainClient ? (DomainClient)this.client : DomainClient.Factory.create((ModelControllerClient)this.client);
        return new DomainDeployment(domainClient, this.domain, this.getContent(), this.getName(), this.getRuntimeName(), this.getType(), this.getMatchPattern(), this.getMatchPatternStrategy());
    }
}

