/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.batch")
    private boolean batch;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="system-properties")
    private Map<String, String> systemProperties;
    @Parameter
    private List<File> propertiesFiles = new ArrayList<File>();
    @Deprecated
    @Parameter(alias="execute-commands")
    private Commands executeCommands;
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true", property="wildfly.failOnError")
    private boolean failOnError = true;
    @Parameter(name="offline", defaultValue="false", property="wildfly.offline")
    private boolean offline = false;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping commands execution");
            return;
        }
        Properties currentSystemProperties = System.getProperties();
        try {
            this.getLog().debug((CharSequence)"Executing commands");
            Properties newSystemProperties = new Properties(currentSystemProperties);
            if (this.propertiesFiles != null) {
                for (File file : this.propertiesFiles) {
                    ExecuteCommandsMojo.parseProperties(file, newSystemProperties);
                }
            }
            if (this.systemProperties != null) {
                newSystemProperties.putAll(this.systemProperties);
            }
            System.setProperties(newSystemProperties);
            try (ModelControllerClient client = this.createClient();){
                this.commandExecutor.execute(client, this.jbossHome, this.getCommands());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not execute commands.", (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to parse properties.", (Throwable)e);
        }
        finally {
            System.setProperties(currentSystemProperties);
        }
    }

    private Commands getCommands() {
        if (this.executeCommands != null) {
            return this.executeCommands;
        }
        return new Commands(this.batch, this.commands, this.scripts, this.failOnError, this.offline);
    }

    private static void parseProperties(File file, Properties properties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
    }
}

