/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.wildfly.common.expression.Expression;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.cli.ModuleEnvironment;
import org.wildfly.plugin.common.ServerOperations;

@Named
@Singleton
public class CommandExecutor {
    public void execute(ModelControllerClient client, Commands commands) throws IOException {
        this.execute(client, (Path)null, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ModelControllerClient client, Path wildflyHome, Commands commands) throws IOException {
        if (wildflyHome != null) {
            try {
                System.setProperty("jboss.home.dir", wildflyHome.toString());
                this.executeCommands(client, commands);
            }
            finally {
                System.clearProperty("jboss.home.dir");
            }
        } else {
            this.executeCommands(client, commands);
        }
    }

    public void execute(ModelControllerClient client, String wildflyHome, Commands commands) throws IOException {
        Path path = null;
        if (wildflyHome != null) {
            path = Paths.get(wildflyHome, new String[0]);
        }
        this.execute(client, path, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands(ModelControllerClient client, Commands commands) throws IOException {
        if (commands.hasCommands() || commands.hasScripts()) {
            try {
                ModuleEnvironment.initJaxp();
                NonClosingModelControllerClient c = new NonClosingModelControllerClient(client);
                CommandContext ctx = this.create(commands, c);
                try {
                    if (commands.isBatch()) {
                        CommandExecutor.executeBatch(ctx, commands.getCommands());
                    } else {
                        CommandExecutor.executeCommands(ctx, commands.getCommands(), commands.isFailOnError());
                    }
                    CommandExecutor.executeScripts(ctx, commands.getScripts(), commands.isFailOnError());
                }
                finally {
                    ctx.terminateSession();
                    ctx.bindClient(null);
                }
            }
            finally {
                ModuleEnvironment.restorePlatform();
            }
        }
    }

    private static void executeScripts(CommandContext ctx, Iterable<File> scripts, boolean failOnError) {
        for (File script : scripts) {
            try {
                CommandExecutor.executeCommands(ctx, Files.readAllLines(script.toPath(), StandardCharsets.UTF_8), failOnError);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to process file '" + script.getAbsolutePath() + "'", e);
            }
        }
    }

    private static void executeCommands(CommandContext ctx, Iterable<String> commands, boolean failOnError) {
        for (String cmd : commands) {
            try {
                Expression expression = Expression.compile((String)cmd, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX});
                cmd = expression.evaluateWithPropertiesAndEnvironment(false);
                if (failOnError) {
                    ctx.handle(cmd);
                    continue;
                }
                ctx.handleSafe(cmd);
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
            }
            catch (CommandLineException e) {
                throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), e);
            }
        }
    }

    private static void executeBatch(CommandContext ctx, Iterable<String> commands) throws IOException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new IllegalArgumentException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    private CommandContext create(Commands commands, ModelControllerClient client) {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            if (!commands.isOffline()) {
                commandContext.bindClient(client);
            } else {
                System.setProperty("org.wildfly.logging.skipLogManagerCheck", "true");
            }
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    private static class NonClosingModelControllerClient
    implements ModelControllerClient {
        private final ModelControllerClient delegate;

        NonClosingModelControllerClient(ModelControllerClient delegate) {
            this.delegate = delegate;
        }

        public ModelNode execute(ModelNode operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(Operation operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.executeOperation(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeOperationAsync(operation, messageHandler);
        }

        public void close() throws IOException {
        }
    }
}

