/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.cli.OfflineCLIExecutor;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.StandardOutputStream;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.batch")
    private boolean batch;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="system-properties")
    private Map<String, String> systemProperties;
    @Parameter
    private List<File> propertiesFiles = new ArrayList<File>();
    @Deprecated
    @Parameter(alias="execute-commands")
    private Commands executeCommands;
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true", property="wildfly.failOnError")
    private boolean failOnError = true;
    @Parameter(name="offline", defaultValue="false", property="wildfly.offline")
    private boolean offline = false;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Inject
    private CommandExecutor commandExecutor;
    @Inject
    private OfflineCLIExecutor offlineCLIExecutor;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block44: {
            if (this.skip) {
                this.getLog().debug((CharSequence)"Skipping commands execution");
                return;
            }
            if (this.offline) {
                this.getLog().debug((CharSequence)"Executing offline CLI scripts");
                try (StandardOutputStream out = StandardOutputStream.parse(this.stdout, false);){
                    int exitCode = this.offlineCLIExecutor.execute(this.jbossHome, this.getCommands(), this.getLog(), out, this.systemProperties);
                    if (exitCode != 0) {
                        StringBuilder msg = new StringBuilder("Failed to execute commands: ");
                        out.flush();
                        switch (out.getTarget()) {
                            case COLLECTING: {
                                msg.append(out);
                                break;
                            }
                            case FILE: {
                                Path stdoutPath = out.getStdoutPath();
                                msg.append("See ").append(stdoutPath).append(" for full details of failure.").append(System.lineSeparator());
                                List<String> lines = Files.readAllLines(stdoutPath);
                                lines.subList(Math.max(lines.size() - 4, 0), lines.size()).forEach(line -> msg.append((String)line).append(System.lineSeparator()));
                                break;
                            }
                            case SYSTEM_ERR: 
                            case SYSTEM_OUT: {
                                msg.append("See previous messages for failure messages.");
                                break;
                            }
                            default: {
                                msg.append("Reason unknown");
                            }
                        }
                        throw new MojoExecutionException(msg.toString());
                    }
                    break block44;
                }
                catch (IOException e) {
                    throw new MojoFailureException("Failed to execute scripts.", (Throwable)e);
                }
            }
            Properties currentSystemProperties = System.getProperties();
            try {
                this.getLog().debug((CharSequence)"Executing commands");
                Properties newSystemProperties = new Properties(currentSystemProperties);
                if (this.propertiesFiles != null) {
                    for (File file : this.propertiesFiles) {
                        ExecuteCommandsMojo.parseProperties(file, newSystemProperties);
                    }
                }
                if (this.systemProperties != null) {
                    newSystemProperties.putAll(this.systemProperties);
                }
                System.setProperties(newSystemProperties);
                try (ModelControllerClient client = this.createClient();){
                    this.commandExecutor.execute(client, this.jbossHome, this.getCommands());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not execute commands.", (Exception)e);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to parse properties.", (Throwable)e);
            }
            finally {
                System.setProperties(currentSystemProperties);
            }
        }
    }

    private Commands getCommands() {
        if (this.executeCommands != null) {
            return this.executeCommands;
        }
        return new Commands(this.batch, this.commands, this.scripts, this.failOnError, this.offline);
    }

    private static void parseProperties(File file, Properties properties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
    }
}

