/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.wildfly.common.Assert;
import org.wildfly.plugin.core.ServerProcess;

public class StandardOutputStream
extends OutputStream
implements Closeable {
    private final OutputStream delegate;
    private final Target target;
    private final Path stdoutPath;

    private StandardOutputStream(OutputStream delegate, Target target, Path stdoutPath) {
        this.delegate = delegate;
        this.target = target;
        this.stdoutPath = stdoutPath;
    }

    public static StandardOutputStream parse(String stdout, boolean discardNone) throws IOException {
        Target target;
        OutputStream out;
        Assert.checkNotNullParam((String)"stdout", (Object)stdout);
        Path stdoutPath = null;
        String value = stdout.trim().toLowerCase(Locale.ENGLISH);
        if ("system.out".equals(value)) {
            out = System.out;
            target = Target.SYSTEM_OUT;
        } else if ("system.err".equals(value)) {
            out = System.err;
            target = Target.SYSTEM_ERR;
        } else if ("none".equals(value)) {
            if (discardNone) {
                target = Target.DISCARDING;
                out = ServerProcess.DISCARDING;
            } else {
                target = Target.COLLECTING;
                out = new ByteArrayOutputStream();
            }
        } else {
            target = Target.FILE;
            stdoutPath = Paths.get(value, new String[0]);
            if (Files.notExists(stdoutPath, new LinkOption[0])) {
                Path parent = stdoutPath.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(stdoutPath, new FileAttribute[0]);
            }
            out = new BufferedOutputStream(Files.newOutputStream(stdoutPath, new OpenOption[0]));
        }
        return new StandardOutputStream(out, target, stdoutPath);
    }

    public Path getStdoutPath() {
        return this.stdoutPath;
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.target != Target.SYSTEM_ERR && this.target != Target.SYSTEM_OUT) {
            this.delegate.close();
        }
    }

    public String toString() {
        if (this.target == Target.COLLECTING) {
            return this.delegate.toString();
        }
        return super.toString();
    }

    public static enum Target {
        COLLECTING,
        DISCARDING,
        FILE,
        SYSTEM_ERR,
        SYSTEM_OUT;

    }
}

