/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.wildfly.plugin.common.ClientCallbackHandler;

public class MavenModelControllerClientConfiguration
implements ModelControllerClientConfiguration {
    private final ModelControllerClientConfiguration delegate;
    private final String username;
    private final String password;
    private final CallbackHandler callbackHandler;

    MavenModelControllerClientConfiguration(ModelControllerClientConfiguration delegate, String username, String password) {
        this.delegate = delegate;
        this.username = username;
        this.password = password;
        this.callbackHandler = delegate.getAuthenticationConfigUri() == null ? new ClientCallbackHandler(username, password) : delegate.getCallbackHandler();
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public int getConnectionTimeout() {
        return this.delegate.getConnectionTimeout();
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public Map<String, String> getSaslOptions() {
        return this.delegate.getSaslOptions();
    }

    public SSLContext getSSLContext() {
        return this.delegate.getSSLContext();
    }

    public ExecutorService getExecutor() {
        return this.delegate.getExecutor();
    }

    public String getClientBindAddress() {
        return this.delegate.getClientBindAddress();
    }

    public URI getAuthenticationConfigUri() {
        return this.delegate.getAuthenticationConfigUri();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return this.password.toCharArray();
    }

    public String getController() {
        StringBuilder controller = new StringBuilder();
        if (this.getProtocol() != null) {
            controller.append(this.getProtocol()).append("://");
        }
        if (this.getHost() != null) {
            controller.append(this.getHost());
        } else {
            controller.append("localhost");
        }
        if (this.getPort() > 0) {
            controller.append(':').append(this.getPort());
        }
        return controller.toString();
    }
}

