/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.ScriptWriter;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.core.ServerHelper;

@Singleton
@Named
public class CommandExecutor
extends AbstractLogEnabled {
    public void execute(CommandConfiguration config) throws MojoFailureException, MojoExecutionException {
        if (config.isOffline()) {
            if (!ServerHelper.isValidHomeDirectory((Path)config.getJBossHome())) {
                throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + config.getJBossHome());
            }
            this.executeInNewProcess(config);
        } else if (config.isFork()) {
            this.executeInNewProcess(config);
        } else {
            this.executeInProcess(config);
        }
    }

    private void executeInNewProcess(CommandConfiguration config) throws MojoExecutionException {
        if (!config.getCommands().isEmpty()) {
            Path scriptFile = null;
            try {
                scriptFile = ScriptWriter.create(config);
                this.executeInNewProcess(config, scriptFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed execute commands.", (Exception)e);
            }
            finally {
                if (scriptFile != null) {
                    try {
                        Files.deleteIfExists(scriptFile);
                    }
                    catch (IOException e) {
                        this.getLogger().debug("Failed to deleted CLI script file: " + scriptFile, (Throwable)e);
                    }
                }
            }
        }
        if (!config.getScripts().isEmpty()) {
            for (Path script : config.getScripts()) {
                this.executeInNewProcess(config, script);
            }
        }
    }

    private void executeInNewProcess(CommandConfiguration config, Path scriptFile) throws MojoExecutionException {
        this.getLogger().debug("Executing CLI scripts");
        try {
            StandardOutput out = StandardOutput.parse(config.getStdout(), false);
            int exitCode = this.executeInNewProcess(config, scriptFile, out);
            if (exitCode != 0) {
                StringBuilder msg = new StringBuilder("Failed to execute commands: ");
                switch (out.getTarget()) {
                    case COLLECTING: {
                        msg.append(out);
                        break;
                    }
                    case FILE: {
                        Path stdoutPath = out.getStdoutPath();
                        msg.append("See ").append(stdoutPath).append(" for full details of failure.").append(System.lineSeparator());
                        List<String> lines = Files.readAllLines(stdoutPath);
                        lines.subList(Math.max(lines.size() - 4, 0), lines.size()).forEach(line -> msg.append((String)line).append(System.lineSeparator()));
                        break;
                    }
                    case SYSTEM_ERR: 
                    case SYSTEM_OUT: 
                    case INHERIT: {
                        msg.append("See previous messages for failure messages.");
                        break;
                    }
                    default: {
                        msg.append("Reason unknown");
                    }
                }
                if (config.isFailOnError()) {
                    throw new MojoExecutionException(msg.toString());
                }
                this.getLogger().warn(msg.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute scripts.", (Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    private int executeInNewProcess(CommandConfiguration config, Path scriptFile, StandardOutput stdout) throws MojoExecutionException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeInProcess(CommandConfiguration config) throws MojoExecutionException, MojoFailureException {
        Path jbossHome = config.getJBossHome();
        if (jbossHome != null && !ServerHelper.isValidHomeDirectory((Path)jbossHome)) {
            throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + jbossHome);
        }
        Properties currentSystemProperties = System.getProperties();
        try {
            this.getLogger().debug("Executing commands");
            Properties newSystemProperties = new Properties(currentSystemProperties);
            if (jbossHome != null) {
                newSystemProperties.setProperty("jboss.home", jbossHome.toString());
                newSystemProperties.setProperty("jboss.home.dir", jbossHome.toString());
            }
            for (Path file : config.getPropertiesFiles()) {
                CommandExecutor.parseProperties(file, newSystemProperties);
            }
            newSystemProperties.putAll(config.getSystemProperties());
            System.setProperties(newSystemProperties);
            CommandContext commandContext = null;
            try (ModelControllerClient client = config.getClient();){
                Collection<Path> scripts;
                commandContext = this.createCommandContext(client);
                Collection<String> commands = config.getCommands();
                if (!commands.isEmpty()) {
                    if (config.isBatch()) {
                        CommandExecutor.executeBatch(commandContext, commands);
                    } else {
                        CommandExecutor.executeCommands(commandContext, commands, config.isFailOnError());
                    }
                }
                if (!(scripts = config.getScripts()).isEmpty()) {
                    for (Path scriptFile : scripts) {
                        List<String> cmds = Files.readAllLines(scriptFile, StandardCharsets.UTF_8);
                        if (config.isBatch()) {
                            CommandExecutor.executeBatch(commandContext, cmds);
                            continue;
                        }
                        CommandExecutor.executeCommands(commandContext, cmds, config.isFailOnError());
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not execute commands.", (Exception)e);
            }
            finally {
                if (commandContext != null) {
                    commandContext.terminateSession();
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to parse properties.", (Throwable)e);
        }
        finally {
            System.setProperties(currentSystemProperties);
        }
    }

    private static void executeCommands(CommandContext ctx, Iterable<String> commands, boolean failOnError) throws MojoExecutionException {
        for (String cmd : commands) {
            try {
                if (failOnError) {
                    ctx.handle(cmd);
                    continue;
                }
                ctx.handleSafe(cmd);
            }
            catch (CommandFormatException e) {
                throw new MojoExecutionException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
            }
        }
    }

    private static void executeBatch(CommandContext ctx, Iterable<String> commands) throws IOException, MojoExecutionException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new MojoExecutionException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new MojoExecutionException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    private CommandContext createCommandContext(ModelControllerClient client) {
        CommandContext commandContext = null;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        catch (Exception e) {
            if (commandContext != null) {
                commandContext.terminateSession();
            }
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    private static void parseProperties(Path file, Properties properties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            properties.load(reader);
        }
    }

    private static /* synthetic */ void lambda$executeInNewProcess$1(CliCommandBuilder builder, String key, String value) {
        builder.addJavaOption(String.format("-D%s=%s", key, value));
    }
}

