/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Environment {
    private static final String[] MODULAR_JVM_ARGUMENTS = new String[]{"--add-exports=java.base/sun.nio.ch=ALL-UNNAMED", "--add-exports=jdk.unsupported/sun.reflect=ALL-UNNAMED", "--add-exports=jdk.unsupported/sun.misc=ALL-UNNAMED", "--add-modules=java.se"};
    private static final Logger LOGGER = Logger.getLogger(Environment.class);
    private static final boolean WINDOWS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModularJvm(Path javaHome) {
        boolean result;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Environment.getJavaCommand(javaHome));
        cmd.add("--add-modules=java.se");
        cmd.add("-version");
        ProcessBuilder builder = new ProcessBuilder(cmd);
        Process process = null;
        Path stdout = null;
        try {
            stdout = Files.createTempFile("stdout", ".txt", new FileAttribute[0]);
            process = builder.redirectErrorStream(true).redirectOutput(stdout.toFile()).start();
            if (process.waitFor(1L, TimeUnit.SECONDS)) {
                result = process.exitValue() == 0;
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)Environment.getStdoutMessage("The process timed out waiting for the response.", stdout));
                }
                result = false;
            }
        }
        catch (IOException | InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)Environment.getStdoutMessage("The process ended in error.", stdout), (Throwable)e);
            }
            result = false;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
            if (stdout != null) {
                try {
                    Files.deleteIfExists(stdout);
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static String[] getModularJvmArguments() {
        return Arrays.copyOf(MODULAR_JVM_ARGUMENTS, MODULAR_JVM_ARGUMENTS.length);
    }

    public static String getJavaCommand(Path javaHome) {
        Path resolvedJavaHome = javaHome == null ? Environment.findJavaHome() : javaHome;
        String exe = resolvedJavaHome == null ? "java" : resolvedJavaHome.resolve("bin").resolve("java").toString();
        if (exe.contains(" ")) {
            return "\"" + exe + "\"";
        }
        if (WINDOWS) {
            return exe + ".exe";
        }
        return exe;
    }

    private static Path findJavaHome() {
        String path = WildFlySecurityManager.getPropertyPrivileged((String)"java.home", null);
        if (path != null) {
            path = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAVA_HOME", null);
        }
        if (path == null) {
            return null;
        }
        Path resolved = Paths.get(path, new String[0]);
        if (Files.exists(resolved, new LinkOption[0])) {
            return resolved;
        }
        return null;
    }

    private static String getStdoutMessage(String message, Path file) {
        StringBuilder result = new StringBuilder(message);
        try {
            List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
            for (String line : lines) {
                result.append(System.lineSeparator()).append(line);
            }
        }
        catch (IOException e) {
            result.append(System.lineSeparator()).append("Failed to read the stdout: ").append(e.getMessage());
        }
        return result.toString();
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        WINDOWS = os.contains("win");
    }
}

