/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugin.provision.ApplicationImageInfo;
import org.wildfly.plugin.provision.ExecUtil;
import org.wildfly.plugin.provision.PackageServerMojo;

@Mojo(name="image", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class ApplicationImageMojo
extends PackageServerMojo {
    public static final int DOCKER_CMD_CHECK_TIMEOUT = 3000;
    @Parameter(alias="image")
    private ApplicationImageInfo image;

    @Override
    protected String getGoal() {
        return "image";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.image == null) {
            this.image = new ApplicationImageInfo();
        }
        try {
            String runtimeImage = this.image.getWildFlyRuntimeImage();
            this.getLog().info((CharSequence)String.format("Generating Dockerfile %s from base image %s", Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("Dockerfile"), runtimeImage));
            this.generateDockerfile(runtimeImage, Paths.get(this.project.getBuild().getDirectory(), new String[0]), this.provisioningDir);
            if (!this.image.build) {
                return;
            }
            if (!this.isDockerBinaryAvailable(this.image.dockerBinary)) {
                throw new MojoExecutionException(String.format("Unable to build application image with %s. Please check your %s installation", this.image.dockerBinary, this.image.dockerBinary));
            }
            String image = this.image.getApplicationImageName(this.project.getArtifactId());
            boolean buildSuccess = this.buildApplicationImage(image, runtimeImage);
            if (!buildSuccess) {
                throw new MojoExecutionException(String.format("Unable to build application image %s", image));
            }
            this.getLog().info((CharSequence)String.format("Successfully built application image %s", image));
            if (this.image.push) {
                this.logToRegistry();
                boolean pushSuccess = this.pushApplicationImage(image);
                if (!pushSuccess) {
                    throw new MojoExecutionException(String.format("Unable to push application image %s", image));
                }
                this.getLog().info((CharSequence)String.format("Successfully pushed application image %s", image));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void logToRegistry() throws MojoExecutionException {
        String registry = this.image.registry;
        if (registry == null) {
            this.getLog().info((CharSequence)"Registry was not set. Using docker.io");
        }
        if (this.image.user != null && this.image.password != null) {
            String[] dockerArgs = new String[]{"login", registry, "-u", this.image.user, "-p", this.image.password};
            boolean loginSuccessful = ExecUtil.exec(this.getLog(), this.image.dockerBinary, dockerArgs);
            if (!loginSuccessful) {
                throw new MojoExecutionException(String.format("Could not log to the container registry with the command %s %s %s", this.image.dockerBinary, String.join((CharSequence)" ", Arrays.copyOf(dockerArgs, dockerArgs.length - 1)), "*******"));
            }
        }
    }

    private boolean buildApplicationImage(String image, String runtimeImage) throws IOException {
        this.getLog().info((CharSequence)String.format("Building application image %s using %s.", image, this.image.dockerBinary));
        CharSequence[] dockerArgs = new String[]{"build", "-t", image, "."};
        this.getLog().info((CharSequence)String.format("Executing the following command to build application image: '%s %s'", this.image.dockerBinary, String.join((CharSequence)" ", dockerArgs)));
        return ExecUtil.exec(this.getLog(), Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile(), this.image.dockerBinary, (String[])dockerArgs);
    }

    private boolean pushApplicationImage(String image) {
        this.getLog().info((CharSequence)String.format("Pushing application image %s using %s.", image, this.image.dockerBinary));
        CharSequence[] dockerArgs = new String[]{"push", image};
        this.getLog().info((CharSequence)String.format("Executing the following command to push application image: '%s %s'", this.image.dockerBinary, String.join((CharSequence)" ", dockerArgs)));
        return ExecUtil.exec(this.getLog(), Paths.get("target", new String[0]).toFile(), this.image.dockerBinary, (String[])dockerArgs);
    }

    private void generateDockerfile(String runtimeImage, Path targetDir, String wildflyDirectory) throws IOException {
        Files.writeString(targetDir.resolve("Dockerfile"), (CharSequence)("FROM " + runtimeImage + "\nCOPY --chown=jboss:root " + wildflyDirectory + " $JBOSS_HOME\nRUN chmod -R ug+rwX $JBOSS_HOME"), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private boolean isDockerBinaryAvailable(String dockerBinary) {
        try {
            if (!ExecUtil.execSilentWithTimeout(Duration.ofMillis(3000L), dockerBinary, "-v")) {
                this.getLog().warn((CharSequence)String.format("'%s -v' returned an error code. Make sure your %s binary is correct", dockerBinary, dockerBinary));
                return false;
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)String.format("No %s binary found or general error: %s", dockerBinary, e));
            return false;
        }
        return true;
    }
}

