/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.core.GalleonUtils;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.ModulesPath;
import org.wildfly.plugin.server.ServerContext;
import org.wildfly.plugin.server.ServerType;

public abstract class AbstractServerStartMojo
extends AbstractServerConnection {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File targetDir;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    protected String jbossHome;
    @Parameter(alias="feature-pack-location", property="wildfly.feature-pack.location")
    private String featurePackLocation;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="provisioning-dir", property="wildfly.provisioning.dir", defaultValue="server")
    private String provisioningDir;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(property="wildfly.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="wildfly.debug.host", defaultValue="*")
    private String debugHost;
    @Parameter(property="wildfly.debug.port", defaultValue="8787")
    private int debugPort;
    @Parameter(property="wildfly.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    private String[] serverArgs;
    @Parameter(defaultValue="false", property="wildfly.skip")
    protected boolean skip;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;
    @Parameter
    private Map<String, String> env;
    private final AtomicBoolean initialized = new AtomicBoolean();
    protected MavenRepoManager mavenRepoManager;

    protected void init() throws MojoExecutionException {
        if (this.initialized.compareAndSet(false, true)) {
            MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
            this.mavenRepoManager = this.createMavenRepoManager();
        }
    }

    protected MavenRepoManager createMavenRepoManager() throws MojoExecutionException {
        return new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
    }

    protected ServerContext startServer(ServerType serverType) throws MojoExecutionException, MojoFailureException {
        ServerContext serverContext;
        block15: {
            Log log = this.getLog();
            this.init();
            final Path jbossHome = this.provisionIfRequired(this.targetDir.toPath().resolve(this.provisioningDir));
            if (!ServerHelper.isValidHomeDirectory((Path)jbossHome)) {
                throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
            }
            StandardOutput out = this.standardOutput();
            ModelControllerClient client = this.createClient();
            try {
                if (ServerHelper.isStandaloneRunning((ModelControllerClient)client) || ServerHelper.isDomainRunning((ModelControllerClient)client)) {
                    throw new MojoExecutionException(String.format("%s server is already running?", new Object[]{serverType}));
                }
                final CommandBuilder commandBuilder = this.createCommandBuilder(jbossHome);
                log.info((CharSequence)String.format("%s server is starting up.", new Object[]{serverType}));
                Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true);
                if (this.env != null) {
                    launcher.addEnvironmentVariables(this.env);
                }
                out.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
                final Process process = launcher.launch();
                out.startConsumer(process);
                if (serverType == ServerType.DOMAIN) {
                    ServerHelper.waitForDomain((Process)process, (ModelControllerClient)DomainClient.Factory.create((ModelControllerClient)client), (long)this.startupTimeout);
                } else {
                    ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
                }
                if (!process.isAlive()) {
                    throw new MojoExecutionException("The process has been terminated before the start goal has completed.");
                }
                serverContext = new ServerContext(){

                    @Override
                    public Process process() {
                        return process;
                    }

                    @Override
                    public CommandBuilder commandBuilder() {
                        return commandBuilder;
                    }

                    @Override
                    public Path jbossHome() {
                        return jbossHome;
                    }
                };
                if (client == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("The server failed to start", e);
                }
            }
            client.close();
        }
        return serverContext;
    }

    protected abstract CommandBuilder createCommandBuilder(Path var1) throws MojoExecutionException;

    protected StandardOutput standardOutput() throws IOException {
        return StandardOutput.parse(null, false);
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    protected StandaloneCommandBuilder createStandaloneCommandBuilder(Path jbossHome, String serverConfig) throws MojoExecutionException {
        Path javaHomePath;
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)jbossHome).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        if (this.debug) {
            commandBuilder.addJavaOptions(new String[]{String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%s:%d", this.debugSuspend ? "y" : "n", this.debugHost, this.debugPort)});
        }
        if (serverConfig != null) {
            commandBuilder.setServerConfiguration(serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        Path path = javaHomePath = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        if (Environment.isModularJvm(javaHomePath)) {
            commandBuilder.addJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    protected DomainCommandBuilder createDomainCommandBuilder(Path jbossHome, String domainConfig, String hostConfig) throws MojoExecutionException {
        Path javaHome = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        DomainCommandBuilder commandBuilder = (DomainCommandBuilder)DomainCommandBuilder.of((Path)jbossHome, (Path)javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setProcessControllerJavaOptions(this.javaOpts).setHostControllerJavaOptions(this.javaOpts);
        }
        if (domainConfig != null) {
            commandBuilder.setDomainConfiguration(domainConfig);
        }
        if (hostConfig != null) {
            commandBuilder.setHostConfiguration(hostConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        if (Environment.isModularJvm(javaHome)) {
            commandBuilder.addHostControllerJavaOptions(Environment.getModularJvmArguments());
            commandBuilder.addProcessControllerJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getHostControllerJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    protected Path provisionIfRequired(Path installDir) throws MojoFailureException, MojoExecutionException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        try {
            if (!Files.exists(installDir, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Provisioning default server in " + installDir));
                GalleonUtils.provision((Path)installDir, (String)this.resolveFeaturePackLocation(), (String)this.version, (MavenRepoManager)this.mavenRepoManager);
            }
            return installDir;
        }
        catch (ProvisioningException ex) {
            throw new MojoFailureException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void addUsers(Path wildflyHome, Path javaHome) throws IOException {
        if (this.addUser != null && this.addUser.hasUsers()) {
            this.getLog().info((CharSequence)("Adding users: " + this.addUser));
            this.addUser.addUsers(wildflyHome, javaHome);
        }
    }

    private String resolveFeaturePackLocation() {
        return this.featurePackLocation == null ? this.getDefaultFeaturePackLocation() : this.featurePackLocation;
    }

    protected String getDefaultFeaturePackLocation() {
        return "wildfly@maven(org.jboss.universe:community-universe)";
    }
}

