/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.dev;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.core.ContainerDescription;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentDescription;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.FeaturePack;
import org.wildfly.plugin.core.GalleonUtils;
import org.wildfly.plugin.core.PluginProgressTracker;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.core.UndeployDescription;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.dev.CompiledSourceHandler;
import org.wildfly.plugin.dev.ResourceHandler;
import org.wildfly.plugin.dev.WatchContext;
import org.wildfly.plugin.dev.WatchHandler;
import org.wildfly.plugin.dev.WebAppResourceHandler;
import org.wildfly.plugin.provision.ChannelConfiguration;
import org.wildfly.plugin.provision.ChannelMavenArtifactRepositoryManager;
import org.wildfly.plugin.server.AbstractServerStartMojo;
import org.wildfly.plugin.server.ServerContext;
import org.wildfly.plugin.server.ServerType;
import org.wildfly.plugin.server.VersionComparator;

@Mojo(name="dev", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class DevMojo
extends AbstractServerStartMojo {
    private static final String ORG_APACHE_MAVEN_PLUGINS = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String MAVEN_COMPILER_GOAL = "compile";
    private static final String MAVEN_WAR_PLUGIN = "maven-war-plugin";
    private static final String MAVEN_EXPLODED_GOAL = "exploded";
    private static final String MAVEN_WAR_GOAL = "war";
    private static final String MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String MAVEN_RESOURCES_GOAL = "resources";
    private static final Set<String> POST_COMPILE_PHASES = Set.of("compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private static final Map<String, String> EXPLODED_WAR_PARAMETERS = Map.ofEntries(Map.entry("archive", ""), Map.entry("archiveClasses", "2.0.1"), Map.entry("containerConfigXML", ""), Map.entry("delimiters", "3.0.0"), Map.entry("dependentWarExcludes", ""), Map.entry("dependentWarIncludes", ""), Map.entry("escapeString", "2.1-beta-1"), Map.entry("escapedBackslashesInFilePath", "2.1-alpha-2"), Map.entry("failOnMissingWebXml", "3.3.0"), Map.entry("filteringDeploymentDescriptors", "2.1-alpha-2"), Map.entry("filters", ""), Map.entry("includeEmptyDirectories", "2.4"), Map.entry("nonFilteredFileExtensions", "2.1-alpha-2"), Map.entry("outdatedCheckPath", "3.3.1"), Map.entry("outputFileNameMapping", "2.1-alpha-1"), Map.entry("outputTimestamp", "3.3.0"), Map.entry("overlays", "2.1-alpha-1"), Map.entry("recompressZippedFiles", "2.3"), Map.entry("resourceEncoding", "2.3"), Map.entry("supportMultiLineFiltering", "2.4"), Map.entry("useDefaultDelimiters", "3.0.0"), Map.entry("useJvmChmod", "2.4"), Map.entry("warSourceDirectory", ""), Map.entry("warSourceExcludes", ""), Map.entry("warSourceIncludes", ""), Map.entry("webappDirectory", ""), Map.entry("webResources", ""), Map.entry("webXml", ""), Map.entry("workDirectory", ""));
    private static final Map<String, String> WAR_PARAMETERS = Map.ofEntries(Map.entry("archive", ""), Map.entry("archiveClasses", "2.0.1"), Map.entry("attachClasses", "2.1-alpha-2"), Map.entry("containerConfigXML", ""), Map.entry("classesClassifier", "2.1-alpha-2"), Map.entry("classifier", ""), Map.entry("delimiters", "3.0.0"), Map.entry("dependentWarExcludes", ""), Map.entry("dependentWarIncludes", ""), Map.entry("escapeString", "2.1-beta-1"), Map.entry("escapedBackslashesInFilePath", "2.1-alpha-2"), Map.entry("failOnMissingWebXml", "2.1-alpha-2"), Map.entry("filteringDeploymentDescriptors", "2.1-alpha-2"), Map.entry("filters", ""), Map.entry("includeEmptyDirectories", "2.4"), Map.entry("nonFilteredFileExtensions", "2.1-alpha-2"), Map.entry("outdatedCheckPath", ""), Map.entry("outputDirectory", "3.3.1"), Map.entry("outputFileNameMapping", "2.1-alpha-1"), Map.entry("outputTimestamp", "3.3.0"), Map.entry("packagingExcludes", "2.1-alpha-2"), Map.entry("packagingIncludes", "2.1-beta-1"), Map.entry("primaryArtifact", ""), Map.entry("overlays", "2.1-alpha-1"), Map.entry("recompressZippedFiles", "2.3"), Map.entry("resourceEncoding", "2.3"), Map.entry("supportMultiLineFiltering", "2.4"), Map.entry("useDefaultDelimiters", "3.0.0"), Map.entry("useJvmChmod", "2.4"), Map.entry("warSourceDirectory", ""), Map.entry("warSourceExcludes", ""), Map.entry("warSourceIncludes", ""), Map.entry("webappDirectory", ""), Map.entry("webResources", ""), Map.entry("webXml", ""), Map.entry("workDirectory", ""));
    private final Map<WatchKey, WatchContext> watchedDirectories = new HashMap<WatchKey, WatchContext>();
    @Component
    private BuildPluginManager pluginManager;
    @Inject
    private CommandExecutor commandExecutor;
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(property="wildfly.dev.web.extensions", alias="web-extensions")
    private List<String> webExtensions = new ArrayList<String>();
    @Parameter(property="wildfly.dev.ignore.patterns", alias="ignore-patterns")
    private List<String> ignorePatterns = new ArrayList<String>();
    @Parameter(property="wildfly.dev.remote", defaultValue="false")
    private boolean remote;
    @Parameter(alias="galleon-options")
    private Map<String, String> galleonOptions = Collections.emptyMap();
    @Parameter(alias="offline-provisioning", defaultValue="false", property="wildfly.provisioning.offline")
    private boolean offlineProvisioning;
    @Parameter(alias="overwrite-provisioned-server", defaultValue="false", property="wildfly.provisioning.overwrite-provisioned-server")
    private boolean overwriteProvisionedServer;
    @Parameter(alias="feature-packs", property="wildfly.provisioning.feature-packs")
    private List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="layers", property="wildfly.provisioning.layers")
    private List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", property="wildfly.provisioning.layers.excluded")
    private List<String> excludedLayers = Collections.emptyList();
    @Parameter(property="wildfly.channels")
    private List<ChannelConfiguration> channels;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    private final List<Pattern> ignoreUpdatePatterns = new ArrayList<Pattern>();
    private final Set<String> allowedWarPluginParams = new HashSet<String>();
    private String warGoal = "exploded";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageType packageType = PackageType.resolve(this.project);
        if (!MAVEN_WAR_GOAL.equalsIgnoreCase(packageType.getPackaging())) {
            throw new MojoExecutionException("The dev goal only works for WAR deployments");
        }
        ServerContext context = null;
        if (this.remote) {
            this.init();
            this.warGoal = MAVEN_WAR_GOAL;
        } else {
            context = this.startServer(ServerType.STANDALONE);
        }
        try {
            if (this.needsCompile()) {
                this.triggerResources();
                this.triggerCompile();
                this.triggerWarGoal();
            }
            try (WatchService watcher = FileSystems.getDefault().newWatchService();){
                CompiledSourceHandler sourceHandler = new CompiledSourceHandler();
                this.registerDir(watcher, Path.of(this.project.getBuild().getSourceDirectory(), new String[0]), sourceHandler);
                for (Resource resource : this.project.getResources()) {
                    this.registerDir(watcher, Path.of(resource.getDirectory(), new String[0]), new ResourceHandler());
                }
                this.registerDir(watcher, this.resolveWebAppSourceDir(), new WebAppResourceHandler(this.webExtensions));
                try (ModelControllerClient client = this.createClient();){
                    if (!ServerHelper.isStandaloneRunning((ModelControllerClient)client)) {
                        throw new MojoExecutionException("No standalone server appears to be running.");
                    }
                    if (this.remote) {
                        ContainerDescription description = ServerHelper.getContainerDescription((ModelControllerClient)client);
                        this.getLog().info((CharSequence)String.format("Deploying to remote %s container.", description));
                    }
                    CommandConfiguration.Builder builder = (CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)CommandConfiguration.of(this::createClient, this::getClientConfiguration).addCommands(this.commands)).addScripts(this.scripts)).setStdout("none")).setAutoReload(true)).setTimeout(this.timeout);
                    if (context == null) {
                        ((CommandConfiguration.Builder)builder.setOffline(false)).setFork(false);
                    } else {
                        ((CommandConfiguration.Builder)builder.setJBossHome(context.jbossHome())).setFork(true);
                    }
                    this.commandExecutor.execute(builder.build(), this.mavenRepoManager);
                    DeploymentManager deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
                    Deployment deployment = this.getDeploymentContent();
                    try {
                        DeploymentResult result = deploymentManager.forceDeploy(deployment);
                        if (!result.successful()) {
                            throw new MojoExecutionException("Failed to deploy content: " + result.getFailureMessage());
                        }
                        if (this.remote) {
                            this.getLog().info((CharSequence)String.format("Deployed %s", deployment.toString()));
                        }
                        this.watch(watcher, deploymentManager, deployment);
                    }
                    finally {
                        deploymentManager.undeploy(UndeployDescription.of((DeploymentDescription)deployment));
                        ServerHelper.shutdownStandalone((ModelControllerClient)client);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
        }
        finally {
            if (context != null) {
                context.process().destroyForcibly();
            }
        }
    }

    @Override
    public String goal() {
        return "dev";
    }

    @Override
    protected MavenRepoManager createMavenRepoManager() throws MojoExecutionException {
        if (this.channels == null || this.channels.isEmpty()) {
            return this.offlineProvisioning ? new MavenArtifactRepositoryManager(this.repoSystem, this.session) : new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
        }
        try {
            return new ChannelMavenArtifactRepositoryManager(this.channels, this.repoSystem, this.session, this.repositories, this.getLog(), this.offlineProvisioning);
        }
        catch (MalformedURLException | UnresolvedMavenArtifactException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
        }
    }

    @Override
    protected CommandBuilder createCommandBuilder(Path jbossHome) throws MojoExecutionException {
        return this.createStandaloneCommandBuilder(jbossHome, this.serverConfig);
    }

    public void setWebExtensions(String webExtensions) {
        this.webExtensions = Utils.splitArguments(webExtensions);
    }

    public void setIgnorePatterns(String ignorePatterns) {
        this.ignorePatterns = Utils.splitArguments(ignorePatterns);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Path provisionIfRequired(Path installDir) throws MojoFailureException, MojoExecutionException {
        if (!this.overwriteProvisionedServer && Files.exists(installDir, new LinkOption[0])) {
            this.getLog().info((CharSequence)String.format("A server already exists in %s, provisioning for %s:%s", installDir, this.project.getGroupId(), this.project.getArtifactId()));
            return installDir;
        }
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)this.mavenRepoManager)).setInstallationHome(installDir).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).build();){
            if (this.featurePacks.isEmpty()) {
                Path path = super.provisionIfRequired(installDir);
                return path;
            }
            ProvisioningConfig config = GalleonUtils.buildConfig((ProvisioningManager)pm, this.featurePacks, this.layers, this.excludedLayers, this.galleonOptions, (String)(this.serverConfig == null ? "standalone.xml" : this.serverConfig));
            this.getLog().info((CharSequence)("Provisioning server in " + installDir));
            PluginProgressTracker.initTrackers((ProvisioningManager)pm, (Log)this.getLog());
            pm.provision(config);
            if (!Files.notExists(installDir.resolve("standalone"), new LinkOption[0])) return installDir;
            if (!Files.notExists(installDir.resolve("domain"), new LinkOption[0])) return installDir;
            this.getLog().error((CharSequence)("Invalid galleon provisioning, no server provisioned in " + installDir + ". Make sure that the list of Galleon feature-packs and Galleon layers are properly configured."));
            throw new MojoExecutionException("Invalid plugin configuration, no server provisioned.");
        }
        catch (ProvisioningException e) {
            throw new MojoFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean registerDir(final WatchService watcher, Path dir, final WatchHandler handler) throws IOException {
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            int currentSize = this.watchedDirectories.size();
            final Set registered = this.watchedDirectories.values().stream().map(WatchContext::directory).collect(Collectors.toCollection(HashSet::new));
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!DevMojo.this.project.getBuild().getOutputDirectory().equals(dir.toString())) {
                        if (registered.add(dir)) {
                            WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                            DevMojo.this.watchedDirectories.put(key, WatchContext.of(dir, handler));
                            DevMojo.this.debug("Watching for changes in %s", dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
            return currentSize == this.watchedDirectories.size();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void watch(WatchService watcher, DeploymentManager deploymentManager, Deployment deployment) {
        Path projectDir = this.project.getBasedir().toPath();
        try {
            while (true) {
                WatchKey key = watcher.take();
                for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<Path> ev = watchEvent;
                    this.debug("File changed [%s]: %s", ev.kind().name(), ev.context());
                    Path absolutePath = this.getPath(key, (Path)ev.context());
                    if (absolutePath == null) continue;
                    Path eventPath = absolutePath.getFileName();
                    try {
                        if (this.isIgnoredChange(eventPath)) {
                            this.debug("Ignoring change for %s", eventPath);
                            continue;
                        }
                    }
                    catch (IOException ex) {
                        this.debug("Failed checking %s for ignored state: %s", eventPath, ex);
                    }
                    try {
                        DeploymentResult deploymentResult;
                        WatchHandler.Result result;
                        WatchContext context;
                        block23: {
                            Path relativePath;
                            block24: {
                                context = this.watchedDirectories.get(key);
                                if (context == null) {
                                    this.getLog().warn((CharSequence)String.format("Failed to find context for %s", ev.context()));
                                    continue;
                                }
                                relativePath = projectDir.relativize(absolutePath);
                                if (ev.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                                    DeploymentResult deploymentResult2 = deploymentManager.undeploy(UndeployDescription.of((DeploymentDescription)deployment));
                                    if (!deploymentResult2.successful()) {
                                        this.getLog().warn((CharSequence)String.format("Failed to undeploy application. Unexpected results may occur. Failure: %s", deploymentResult2.getFailureMessage()));
                                        break block23;
                                    } else {
                                        Path path = this.resolveWarDir();
                                        DevMojo.deleteRecursively(path);
                                        this.triggerResources();
                                        this.triggerCompile();
                                        this.triggerWarGoal();
                                        deploymentResult2 = deploymentManager.deploy(deployment);
                                        if (!deploymentResult2.successful()) {
                                            throw new MojoExecutionException("Failed to deploy content: " + deploymentResult2.getFailureMessage());
                                        }
                                        if (!Files.notExists(context.directory(), new LinkOption[0])) continue;
                                        this.watchedDirectories.remove(key);
                                        key.cancel();
                                        continue;
                                    }
                                }
                                if (ev.kind() != StandardWatchEventKinds.ENTRY_CREATE) break block24;
                                if (Files.isDirectory(eventPath, new LinkOption[0])) {
                                    if (this.registerDir(watcher, eventPath, context.handler())) {
                                        this.debug("New directory registered: %s", relativePath);
                                    }
                                    break block23;
                                } else {
                                    Path parent = absolutePath.getParent();
                                    if (parent != null && this.registerDir(watcher, parent, context.handler())) {
                                        this.debug("New directory registered: %s", relativePath);
                                    }
                                    this.debug("A new source file has been created: %s", relativePath);
                                }
                                break block23;
                            }
                            if (ev.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                                this.debug("Source file modified: %s", relativePath);
                            }
                        }
                        if ((result = context.handle(ev, absolutePath)).requiresRecompile()) {
                            this.triggerCompile();
                        }
                        if (result.requiresCopyResources()) {
                            this.triggerResources();
                        }
                        if (this.remote || result.requiresRepackage()) {
                            this.triggerWarGoal();
                        }
                        if (!this.remote && !result.requiresRedeploy() || (deploymentResult = this.remote ? deploymentManager.redeploy(deployment) : deploymentManager.redeployToRuntime((DeploymentDescription)deployment)).successful()) continue;
                        throw new MojoExecutionException("Failed to deploy content: " + deploymentResult.getFailureMessage());
                    }
                    catch (Exception ex) {
                        this.getLog().error((CharSequence)("Exception handling file change: " + ex));
                    }
                }
                key.reset();
            }
        }
        catch (ClosedWatchServiceException key) {
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted during watch.", e);
        }
    }

    private void triggerCompile() throws MojoExecutionException {
        String compilerPluginKey = "org.apache.maven.plugins:maven-compiler-plugin";
        Plugin compilerPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (compilerPlugin != null) {
            this.executeGoal(this.project, compilerPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_COMPILER_PLUGIN, MAVEN_COMPILER_GOAL, this.getPluginConfig(compilerPlugin, MAVEN_COMPILER_GOAL));
        }
    }

    private void triggerWarGoal() throws MojoExecutionException {
        String warPluginKey = "org.apache.maven.plugins:maven-war-plugin";
        Plugin warPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-war-plugin");
        if (warPlugin != null) {
            this.executeGoal(this.project, warPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_WAR_PLUGIN, this.warGoal, this.getWarPluginConfig(warPlugin));
        } else {
            this.getLog().warn((CharSequence)"Can't package war application, war plugin not found");
        }
    }

    private void triggerResources() throws MojoExecutionException {
        List resources = this.project.getResources();
        if (resources.isEmpty()) {
            return;
        }
        Plugin resourcesPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-resources-plugin");
        if (resourcesPlugin == null) {
            return;
        }
        this.executeGoal(this.project, resourcesPlugin, ORG_APACHE_MAVEN_PLUGINS, MAVEN_RESOURCES_PLUGIN, MAVEN_RESOURCES_GOAL, this.getPluginConfig(resourcesPlugin, MAVEN_RESOURCES_GOAL));
    }

    private Path getPath(WatchKey key, Path fileName) {
        WatchContext context = this.watchedDirectories.get(key);
        if (context == null) {
            this.getLog().debug((CharSequence)("No more watching key, ignoring change done to " + fileName));
            return null;
        }
        Path resolved = context.directory().resolve(fileName);
        if (Path.of(this.project.getBuild().getDirectory(), new String[0]).equals(resolved)) {
            return null;
        }
        return resolved;
    }

    private boolean needsCompile() {
        boolean compileNeeded = true;
        for (String goal : this.mavenSession.getGoals()) {
            if (POST_COMPILE_PHASES.contains(goal)) {
                compileNeeded = false;
                break;
            }
            if (!goal.endsWith("wildfly:" + this.goal())) continue;
            break;
        }
        return compileNeeded;
    }

    private void executeGoal(MavenProject project, Plugin plugin, String groupId, String artifactId, String goal, Xpp3Dom config) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)plugin.getVersion()), (List)plugin.getDependencies()), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private Xpp3Dom getPluginConfig(Plugin plugin, String goal) throws MojoExecutionException {
        Xpp3Dom mergedConfig = null;
        if (!plugin.getExecutions().isEmpty()) {
            for (PluginExecution exec : plugin.getExecutions()) {
                if (exec.getConfiguration() == null || !exec.getGoals().contains(goal)) continue;
                mergedConfig = mergedConfig == null ? (Xpp3Dom)exec.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)exec.getConfiguration()), (Boolean)true);
            }
        }
        if (plugin.getConfiguration() != null) {
            mergedConfig = mergedConfig == null ? (Xpp3Dom)plugin.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Boolean)true);
        }
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        if (mergedConfig != null) {
            Set supportedParams = null;
            for (Xpp3Dom child : mergedConfig.getChildren()) {
                if (child.getName().startsWith("test")) continue;
                if (supportedParams == null) {
                    supportedParams = this.getMojoDescriptor(plugin, goal).getParameterMap().keySet();
                }
                if (!supportedParams.contains(child.getName())) continue;
                configuration.addChild(child);
            }
        }
        return configuration;
    }

    private Xpp3Dom getWarPluginConfig(Plugin plugin) {
        Xpp3Dom pluginConfiguration;
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        if (this.allowedWarPluginParams.isEmpty()) {
            String pluginVersion = plugin.getVersion();
            Xpp3Dom[] comparator = new VersionComparator();
            Map<String, String> parameters = this.remote ? WAR_PARAMETERS : EXPLODED_WAR_PARAMETERS;
            this.allowedWarPluginParams.addAll(parameters.entrySet().stream().filter(arg_0 -> DevMojo.lambda$getWarPluginConfig$0((VersionComparator)comparator, pluginVersion, arg_0)).map(Map.Entry::getKey).collect(Collectors.toSet()));
        }
        if ((pluginConfiguration = (Xpp3Dom)plugin.getConfiguration()) != null) {
            for (Xpp3Dom child : pluginConfiguration.getChildren()) {
                if (!this.allowedWarPluginParams.contains(child.getName())) continue;
                configuration.addChild(child);
            }
        }
        MojoExecutor.Element e = new MojoExecutor.Element("webappDirectory", this.resolveWarDir().toAbsolutePath().toString(), new MojoExecutor.Element[0]);
        configuration.addChild(e.toDom());
        return configuration;
    }

    private MojoDescriptor getMojoDescriptor(Plugin plugin, String goal) throws MojoExecutionException {
        try {
            return this.pluginManager.getMojoDescriptor(plugin, goal, this.repositories, this.session);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to obtain descriptor for Maven plugin " + plugin.getId() + " goal " + goal, e);
        }
    }

    private boolean isIgnoredChange(Path file) throws IOException {
        if (this.isHiddenFile(file) || file.getFileName().toString().endsWith("~")) {
            return true;
        }
        for (Pattern pattern : this.getPatterns()) {
            if (!pattern.matcher(file.getFileName().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenFile(Path p) throws IOException {
        if (Environment.isWindows()) {
            DosFileAttributes dosAttrs = Files.readAttributes(p, DosFileAttributes.class, new LinkOption[0]);
            return dosAttrs.isHidden();
        }
        return Files.isHidden(p);
    }

    private List<Pattern> getPatterns() {
        if (!this.ignorePatterns.isEmpty() && this.ignoreUpdatePatterns.isEmpty()) {
            for (String p : this.ignorePatterns) {
                Pattern pattern = Pattern.compile(p);
                this.ignoreUpdatePatterns.add(pattern);
            }
        }
        return this.ignoreUpdatePatterns;
    }

    private Deployment getDeploymentContent() {
        String runtimeName;
        PackageType packageType = PackageType.resolve(this.project);
        String filename = String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension());
        String string = runtimeName = this.name == null || this.name.isBlank() ? filename : this.name;
        if (this.remote) {
            return Deployment.of((Path)Path.of(this.project.getBuild().getDirectory(), new String[0]).resolve(filename));
        }
        return Deployment.of((Path)this.resolveWarDir()).setName(runtimeName).setRuntimeName(runtimeName);
    }

    private Path resolveWebAppSourceDir() {
        String warPluginKey = "org.apache.maven.plugins:maven-war-plugin";
        Plugin warPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-war-plugin");
        Xpp3Dom dom = this.getWarPluginConfig(warPlugin);
        Xpp3Dom warSourceDirectory = dom.getChild("warSourceDirectory");
        if (warSourceDirectory == null) {
            return this.project.getBasedir().toPath().resolve("src").resolve("main").resolve("webapp");
        }
        return Path.of(warSourceDirectory.getValue(), new String[0]);
    }

    private Path resolveWarDir() {
        return Path.of(this.project.getBuild().getDirectory(), new String[0]).resolve(this.project.getBuild().getFinalName());
    }

    private void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)String.format("[WATCH] " + format, args));
    }

    private static void deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
    }

    private static /* synthetic */ boolean lambda$getWarPluginConfig$0(VersionComparator comparator, String pluginVersion, Map.Entry e) {
        return ((String)e.getValue()).isEmpty() || comparator.compare((String)e.getValue(), pluginVersion) <= 0;
    }
}

