/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.plugin.cli.AbstractCommandExecutor;
import org.wildfly.plugin.cli.BaseCommandConfiguration;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.tools.server.ServerManager;

@Singleton
@Named
public class OfflineCommandExecutor
extends AbstractCommandExecutor<BaseCommandConfiguration> {
    @Override
    public void execute(BaseCommandConfiguration config, MavenRepoManager artifactResolver) throws MojoFailureException, MojoExecutionException {
        if (!ServerManager.isValidHomeDirectory((Path)config.getJBossHome())) {
            throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + config.getJBossHome());
        }
        this.executeInNewProcess(config);
    }

    @Override
    protected int executeInNewProcess(BaseCommandConfiguration config, Path scriptFile, StandardOutput stdout) throws MojoExecutionException, IOException {
        CliCommandBuilder builder = this.createCommandBuilder(config, scriptFile);
        return this.launchProcess(builder, config, stdout);
    }
}

