/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.ScanResults;
import org.wildfly.plugin.cli.BaseCommandConfiguration;
import org.wildfly.plugin.cli.CliSession;
import org.wildfly.plugin.cli.OfflineCommandExecutor;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.deployment.MojoDeploymentException;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.provision.AbstractProvisionServerMojo;
import org.wildfly.plugin.provision.GlowConfig;
import org.wildfly.plugin.tools.bootablejar.BootableJarSupport;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class PackageServerMojo
extends AbstractProvisionServerMojo {
    @Deprecated(forRemoval=true, since="5.1")
    public static final String JAR = "jar";
    @Deprecated(forRemoval=true, since="5.1")
    public static final String BOOTABLE_JAR_NAME_RADICAL = "server-";
    @Parameter(alias="extra-server-content-dirs")
    List<String> extraServerContentDirs = Collections.emptyList();
    @Parameter(alias="packaging-scripts")
    private List<CliSession> packagingScripts = new ArrayList<CliSession>();
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(property="wildfly.serverConfig", alias="server-config", defaultValue="standalone.xml")
    String serverConfig;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Deprecated(since="4.1.O")
    @Parameter(property="wildfly.deployment.runtime.name", alias="runtime-name")
    protected String runtimeName;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(defaultValue="false", property="wildfly.package.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.package.deployment.skip")
    protected boolean skipDeployment;
    @Parameter(alias="discover-provisioning-info")
    private GlowConfig discoverProvisioningInfo;
    @Parameter(alias="bootable-jar", required=false, property="wildfly.bootable.jar")
    private boolean bootableJar;
    @Parameter(alias="bootable-jar-name", property="wildfly.bootable.jar.name", defaultValue="${project.artifactId}-bootable.jar")
    private String bootableJarName;
    @Parameter(alias="bootable-jar-install-artifact-classifier", property="wildfly.bootable.jar.classifier", defaultValue="bootable")
    private String bootableJarInstallArtifactClassifier;
    @Parameter(alias="included-dependencies", property="wildfly.included.dependencies")
    private Set<String> includedDependencies = Set.of();
    @Parameter(alias="excluded-dependencies", property="wildfly.excluded.dependencies")
    private Set<String> excludedDependencies = Set.of();
    @Parameter(alias="included-dependency-scope", property="wildfly.included.dependency.scope")
    private String includedDependencyScope;
    @Parameter(alias="excluded-dependency-scope", property="wildfly.excluded.dependency.scope")
    private String excludedDependencyScope;
    @Inject
    private OfflineCommandExecutor commandExecutor;
    private GalleonProvisioningConfig config;
    private Map<String, Path> deployments;

    @Override
    protected GalleonProvisioningConfig getDefaultConfig() throws ProvisioningException {
        return null;
    }

    @Override
    protected GalleonProvisioningConfig buildGalleonConfig(GalleonBuilder pm) throws MojoExecutionException, ProvisioningException {
        GalleonProvisioningConfig galleonProvisioningConfig;
        block12: {
            Map<String, Path> extraDeps;
            if (this.discoverProvisioningInfo == null) {
                this.config = super.buildGalleonConfig(pm);
                return this.config;
            }
            if (this.discoverProvisioningInfo.getContext() != null && "cloud".equals(this.discoverProvisioningInfo.getContext()) && this.bootableJar) {
                throw new MojoExecutionException("The option 'bootableJar' must not be set when discovering provisioning information for the 'cloud' execution context.");
            }
            ArrayList<Path> allDeployments = new ArrayList<Path>();
            Path primaryDeployment = this.getDeploymentContent();
            if (primaryDeployment != null) {
                allDeployments.add(primaryDeployment);
            }
            if (!(extraDeps = this.getDeployments()).isEmpty()) {
                allDeployments.addAll(extraDeps.values());
            }
            ScanResults results = Utils.scanDeployment(this.discoverProvisioningInfo, this.layers, this.excludedLayers, this.featurePacks, this.dryRun, this.getLog(), allDeployments, this.artifactResolver, Paths.get(this.project.getBuild().getDirectory(), new String[0]), pm, this.galleonOptions, this.layersConfigurationFileName);
            try {
                galleonProvisioningConfig = this.config = results.getProvisioningConfig();
                if (results == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
                }
            }
            results.close();
        }
        return galleonProvisioningConfig;
    }

    @Override
    protected String getGoal() {
        return "package";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.getGoal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        super.execute();
    }

    private void deploy(Path deploymentContent, String targetName) throws MojoDeploymentException {
        if (Files.exists(deploymentContent, new LinkOption[0])) {
            Path standaloneDeploymentDir = Path.of(this.provisioningDir, "standalone", "deployments");
            if (!standaloneDeploymentDir.isAbsolute()) {
                standaloneDeploymentDir = Path.of(this.project.getBuild().getDirectory(), new String[0]).resolve(standaloneDeploymentDir);
            }
            try {
                Path deploymentTarget = standaloneDeploymentDir.resolve(targetName);
                this.getLog().info((CharSequence)("Copy deployment " + deploymentContent + " to " + deploymentTarget));
                Files.copy(deploymentContent, deploymentTarget, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoDeploymentException("Could not copy deployment in provisioned server", e);
            }
        } else {
            this.getLog().warn((CharSequence)("The file " + deploymentContent + " doesn't exist, it will be not deployed."));
        }
    }

    private Map<String, Path> getDeployments() throws MojoExecutionException {
        if (this.deployments != null) {
            return this.deployments;
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        Set dependenciesIds = this.project.getDependencies().stream().map(PackageServerMojo::createKey).collect(Collectors.toSet());
        ArtifactFilter dependencyFilter = artifact -> dependenciesIds.contains(PackageServerMojo.createKey(artifact));
        filters.add(dependencyFilter);
        if (!this.includedDependencies.isEmpty()) {
            filters.add(new PatternIncludesArtifactFilter(this.includedDependencies));
        }
        if (!this.excludedDependencies.isEmpty()) {
            filters.add(new PatternExcludesArtifactFilter(this.excludedDependencies));
        }
        if (this.includedDependencyScope != null) {
            filters.add(PackageServerMojo.createScopeFilter(this.includedDependencyScope, true));
        }
        if (this.excludedDependencyScope != null) {
            filters.add(PackageServerMojo.createScopeFilter(this.excludedDependencyScope, false));
        }
        AndArtifactFilter filter = new AndArtifactFilter(filters);
        Set projectArtifacts = this.project.getArtifacts();
        Set deployments = projectArtifacts.stream().filter(arg_0 -> ((ArtifactFilter)filter).include(arg_0)).collect(Collectors.toSet());
        LinkedHashMap<String, Path> deploymentPaths = new LinkedHashMap<String, Path>();
        for (Artifact artifact2 : deployments) {
            File f = artifact2.getFile();
            if (f == null) {
                throw new MojoExecutionException("Deployment not found " + artifact2);
            }
            Path p = f.toPath();
            deploymentPaths.put(p.getFileName().toString(), p);
        }
        this.deployments = Map.copyOf(deploymentPaths);
        return this.deployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serverProvisioned(Path jbossHome) throws MojoExecutionException, MojoFailureException {
        try {
            if (StandardOutput.isFile(this.stdout)) {
                Files.deleteIfExists(Paths.get(this.stdout, new String[0]));
            }
            if (!this.extraServerContentDirs.isEmpty()) {
                this.getLog().info((CharSequence)"Copying extra content to server");
                this.copyExtraContent(jbossHome);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
        }
        if (!this.skipDeployment) {
            Path primaryDeployment = this.getDeploymentContent();
            if (primaryDeployment != null) {
                this.deploy(primaryDeployment, this.getDeploymentTargetName());
            }
            try {
                Map<String, Path> extraPaths = this.getDeployments();
                for (Map.Entry<String, Path> p : extraPaths.entrySet()) {
                    this.deploy(p.getValue(), p.getKey());
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
            }
        }
        try {
            if (!this.packagingScripts.isEmpty()) {
                this.getLog().info((CharSequence)"Excuting CLI commands and scripts");
                for (CliSession session : this.packagingScripts) {
                    List<File> wrappedScripts = this.wrapOfflineScripts(session.getScripts());
                    try {
                        BaseCommandConfiguration cmdConfig = ((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)new BaseCommandConfiguration.Builder().addCommands(this.wrapOfflineCommands(session.getCommands()))).addScripts(wrappedScripts)).addCLIArguments(new String[]{"--echo-command"})).setJBossHome(jbossHome)).setAppend(true)).setStdout(this.stdout)).addPropertiesFiles(this.resolveFiles(session.getPropertiesFiles()))).addJvmOptions(session.getJavaOpts())).setResolveExpression(session.getResolveExpression())).build();
                        this.commandExecutor.execute(cmdConfig, this.artifactResolver);
                    }
                    finally {
                        for (File f : wrappedScripts) {
                            Files.delete(f.toPath());
                        }
                    }
                }
            }
            PackageServerMojo.cleanupServer(jbossHome);
            if (this.bootableJar) {
                this.packageBootableJar(jbossHome, this.config);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
    }

    private void attachJar(Path jarFile) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Attaching bootable jar " + jarFile + " as a project artifact with classifier " + this.bootableJarInstallArtifactClassifier));
        }
        this.projectHelper.attachArtifact(this.project, JAR, this.bootableJarInstallArtifactClassifier, jarFile.toFile());
    }

    private void packageBootableJar(Path jbossHome, GalleonProvisioningConfig activeConfig) throws Exception {
        String jarName = this.bootableJarName;
        Path targetPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path targetJarFile = targetPath.toAbsolutePath().resolve(jarName);
        Files.deleteIfExists(targetJarFile);
        BootableJarSupport.packageBootableJar((Path)targetJarFile, (Path)targetPath, (GalleonProvisioningConfig)activeConfig, (Path)jbossHome, (MavenRepoManager)this.artifactResolver, (MessageWriter)new MvnMessageWriter(this.getLog()));
        this.attachJar(targetJarFile);
        this.getLog().info((CharSequence)("Bootable JAR packaging DONE. To run the server: java -jar " + targetJarFile));
    }

    protected String getDeploymentTargetName() throws MojoExecutionException {
        String targetName = this.runtimeName != null ? this.runtimeName : (this.name != null ? this.name : this.getDeploymentContent().getFileName().toString());
        return targetName;
    }

    private List<File> resolveFiles(List<File> files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        ArrayList<File> resolvedFiles = new ArrayList<File>();
        for (File f : files) {
            resolvedFiles.add(PackageServerMojo.resolvePath(this.project, f.toPath()).toFile());
        }
        return resolvedFiles;
    }

    private List<String> wrapOfflineCommands(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return commands;
        }
        ArrayList<String> offlineCommands = new ArrayList<String>();
        String serverConfigName = this.serverConfig;
        if (!this.layersConfigurationFileName.equals("standalone.xml")) {
            serverConfigName = this.layersConfigurationFileName;
        }
        offlineCommands.add("embed-server --server-config=" + serverConfigName);
        offlineCommands.addAll(commands);
        offlineCommands.add("stop-embedded-server");
        return offlineCommands;
    }

    private List<File> wrapOfflineScripts(List<File> scripts) throws IOException, MojoExecutionException {
        ArrayList<File> wrappedScripts = new ArrayList<File>();
        for (File script : scripts) {
            if (script == null) continue;
            wrappedScripts.add(this.wrapScript(script).toFile());
        }
        return wrappedScripts;
    }

    private Path wrapScript(File script) throws IOException, MojoExecutionException {
        Path tempScript = Files.createTempFile("offline-cli-script", ".cli", new FileAttribute[0]);
        Path resolvedScript = PackageServerMojo.resolvePath(this.project, script.toPath());
        if (!Files.exists(resolvedScript, new LinkOption[0])) {
            throw new MojoExecutionException("CLI script " + resolvedScript + " doesn't exist");
        }
        List<String> cmds = Files.readAllLines(resolvedScript, StandardCharsets.UTF_8);
        List<String> wrappedCommands = this.wrapOfflineCommands(cmds);
        Files.write(tempScript, wrappedCommands, StandardCharsets.UTF_8, new OpenOption[0]);
        return tempScript;
    }

    public void copyExtraContent(Path target) throws MojoExecutionException, IOException {
        for (String path : this.extraServerContentDirs) {
            Path extraContent = Paths.get(path, new String[0]);
            if (Files.notExists(extraContent = PackageServerMojo.resolvePath(this.project, extraContent), new LinkOption[0])) {
                throw new MojoExecutionException("Extra content dir " + extraContent + " doesn't exist");
            }
            if (!Files.isDirectory(extraContent, new LinkOption[0])) {
                throw new MojoExecutionException("Extra content dir " + extraContent + " is not a directory");
            }
            this.warnExtraConfig(extraContent);
            IoUtils.copy((Path)extraContent, (Path)target);
        }
    }

    private void warnExtraConfig(Path extraContentDir) {
        Path config = extraContentDir.resolve("standalone").resolve("configurations").resolve("standalone.xml");
        if (Files.exists(config, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("The file " + config + " overrides the Galleon generated configuration, un-expected behavior can occur when starting the server"));
        }
    }

    protected Path getDeploymentContent() throws MojoExecutionException {
        PackageType packageType = PackageType.resolve(this.project);
        if (packageType.isIgnored()) {
            return null;
        }
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        Path deployment = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(filename);
        if (Files.notExists(deployment, new LinkOption[0])) {
            if (this.filename != null) {
                throw new MojoExecutionException("No deployment found with name " + this.filename);
            }
            if (this.runtimeName != null) {
                throw new MojoExecutionException("No deployment found with name " + filename + ". A runtime-name has been set that indicates that a deployment is expected. A custom file name can be set with the <filename> parameter.");
            }
            this.getLog().warn((CharSequence)"The project doesn't define a deployment artifact to deploy to the server.");
        }
        return deployment;
    }

    private static void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Path tmp = jbossHome.resolve("standalone").resolve("tmp");
        IoUtils.recursiveDelete((Path)tmp);
        Path log = jbossHome.resolve("standalone").resolve("log");
        IoUtils.recursiveDelete((Path)log);
    }

    private static ArtifactFilter createScopeFilter(String scope, boolean includeScope) {
        ScopeArtifactFilter filter = new ScopeArtifactFilter();
        switch (scope) {
            case "compile": {
                filter.setIncludeCompileScope(true);
                break;
            }
            case "provided": {
                filter.setIncludeProvidedScope(true);
                break;
            }
            case "runtime": {
                filter.setIncludeRuntimeScope(true);
                break;
            }
            case "test": {
                filter.setIncludeTestScope(true);
                break;
            }
            case "system": {
                filter.setIncludeSystemScope(true);
            }
        }
        return includeScope ? filter : artifact -> !filter.include(artifact);
    }

    private static String createKey(Dependency dependency) {
        StringBuilder key = new StringBuilder().append(dependency.getGroupId()).append(':').append(dependency.getArtifactId()).append(':').append(dependency.getType());
        if (dependency.getClassifier() != null) {
            key.append(':').append(dependency.getClassifier());
        }
        key.append(':').append(dependency.getVersion());
        return key.toString();
    }

    private static String createKey(Artifact artifact) {
        StringBuilder key = new StringBuilder().append(artifact.getGroupId()).append(':').append(artifact.getArtifactId()).append(':').append(artifact.getType());
        if (artifact.getClassifier() != null) {
            key.append(':').append(artifact.getClassifier());
        }
        key.append(':').append(artifact.getVersion());
        return key.toString();
    }
}

