/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.server.AbstractServerStartMojo;
import org.wildfly.plugin.server.ServerContext;
import org.wildfly.plugin.server.ServerType;
import org.wildfly.plugin.tools.Deployment;
import org.wildfly.plugin.tools.DeploymentManager;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends AbstractServerStartMojo {
    @Inject
    private CommandExecutor commandExecutor;
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="runtime-name", property="wildfly.deployment.runtime.name")
    private String runtimeName;
    @Parameter(property="wildfly.deployment.filename")
    private String filename;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            Log log = this.getLog();
            Path deploymentContent = this.getDeploymentContent();
            if (Files.notExists(deploymentContent, new LinkOption[0])) {
                throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentContent.toAbsolutePath()));
            }
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            ServerContext context = this.startServer(ServerType.STANDALONE);
            Process process = context.process();
            try (ModelControllerClient client = this.createClient();){
                CommandConfiguration cmdConfig = ((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)CommandConfiguration.of(this::createClient, this::getClientConfiguration).addCommands(this.commands)).addScripts(this.scripts)).setJBossHome(context.jbossHome())).setAutoReload(false)).setFork(true)).setStdout("none")).setTimeout(this.timeout)).build();
                this.commandExecutor.execute(cmdConfig, this.mavenRepoManager);
                process = this.actOnServerState(client, context).process();
                Deployment deployment = Deployment.of((Path)deploymentContent).setName(this.name).setRuntimeName(this.runtimeName);
                DeploymentManager deploymentManager = DeploymentManager.create((ModelControllerClient)client);
                deploymentManager.forceDeploy(deployment);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                if (process != null) {
                    process.destroyForcibly().waitFor(10L, TimeUnit.SECONDS);
                }
                throw e;
            }
            try {
                boolean keepRunning = true;
                while (keepRunning) {
                    int exitCode = process.waitFor();
                    if (exitCode == 10) {
                        process.destroy();
                        process = this.startServer(ServerType.STANDALONE).process();
                        continue;
                    }
                    keepRunning = false;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("The server failed to start", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    @Override
    protected CommandBuilder createCommandBuilder(Path jbossHome) throws MojoExecutionException {
        return this.createStandaloneCommandBuilder(jbossHome, this.serverConfig);
    }

    @Override
    public String goal() {
        return "run";
    }

    private Path getDeploymentContent() {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return this.targetDir.toPath().resolve(filename);
    }
}

