/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import org.wildfly.plugin.tools.server.Configuration;

public class ServerManagerException
extends RuntimeException {
    ServerManagerException(String msg) {
        super(msg);
    }

    ServerManagerException(String format, Object ... args) {
        super(String.format(format, args));
    }

    ServerManagerException(Throwable cause, String msg) {
        super(msg, cause);
    }

    ServerManagerException(Throwable cause, String format, Object ... args) {
        super(String.format(format, args), cause);
    }

    static ServerManagerException startException(Configuration<?> configuration, Throwable cause) {
        return new ServerManagerException(cause, ServerManagerException.createStartFailureMessage(configuration));
    }

    private static String createStartFailureMessage(Configuration<?> configuration) {
        if (configuration.commandBuilder() != null) {
            return "Failed to start server with command: " + configuration.commandBuilder().build();
        }
        return String.format("Failed to start %s server.", configuration.launchType().name().toLowerCase());
    }
}

