/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.job;

import java.util.logging.Logger;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.batch.model.Contact;

@Named(value="contactFormatter")
public class ContactsFormatter
implements ItemProcessor {
    @Inject
    private Logger log;

    public Object processItem(Object item) throws Exception {
        Contact c = (Contact)item;
        String name = c.getName();
        String newName = Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase();
        c.setName(newName);
        String phone = c.getPhone();
        String newPhone = phone.replaceFirst("(\\d{3})(\\d{3})(\\d+)", "($1)-$2-$3");
        c.setPhone(newPhone);
        this.log.info(String.format("Register #%d - Changing name %s -> %s | phone  %s -> %s", c.getId(), name, newName, phone, newPhone));
        return c;
    }
}

