/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.job;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.jboss.as.quickstarts.batch.model.Contact;

@Named(value="contactsPersister")
public class ContactsPersister
extends AbstractItemWriter {
    @Inject
    private EntityManager entityManager;
    @Inject
    private Logger log;
    private Boolean hasCheckPoint;

    public void open(Serializable checkpoint) throws Exception {
        if (checkpoint == null) {
            this.log.info("No checkpoint detected. Cleaning the Database");
            this.entityManager.createQuery("DELETE FROM Contact c").executeUpdate();
            this.hasCheckPoint = true;
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (int i = 0; i < items.size(); ++i) {
            Contact c = (Contact)items.get(i);
            this.entityManager.persist((Object)c);
            this.entityManager.flush();
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return this.hasCheckPoint;
    }
}

