/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.batch.job.ChunkCheckpoint;
import org.jboss.as.quickstarts.batch.model.Contact;

@Named(value="recordsReader")
public class RecordsReader
implements ItemReader {
    @Inject
    @BatchProperty
    private String separatorRegex;
    @Inject
    @BatchProperty
    private String fileName;
    @Inject
    private Logger log;
    private BufferedReader br;
    private ChunkCheckpoint checkpoint;

    public void close() throws Exception {
        this.br.close();
    }

    public void open(Serializable previousCheckpoint) throws Exception {
        this.checkpoint = previousCheckpoint == null ? new ChunkCheckpoint() : (ChunkCheckpoint)previousCheckpoint;
        this.br = new BufferedReader(new FileReader(new File(System.getProperty("java.io.tmpdir"), this.fileName)));
        long lineNumber = this.checkpoint.getLineNumber();
        if (lineNumber > 0L) {
            this.log.info("Skipping to line " + lineNumber + " as marked by previous checkpoint");
        }
        for (long i = 0L; i < lineNumber; ++i) {
            this.br.readLine();
        }
    }

    public Contact readItem() throws Exception {
        String line = this.br.readLine();
        if (line != null) {
            String[] fields = line.split(this.separatorRegex);
            Contact contact = new Contact();
            contact.setId(Integer.valueOf(Integer.parseInt(fields[0])));
            contact.setName(fields[1]);
            contact.setPhone(fields[2]);
            this.checkpoint.increase();
            return contact;
        }
        return null;
    }

    public Serializable checkpointInfo() throws Exception {
        return this.checkpoint;
    }
}

