/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.job.listener;

import java.util.List;
import java.util.logging.Logger;
import javax.batch.api.chunk.listener.AbstractItemWriteListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="persistListener")
public class PersistListener
extends AbstractItemWriteListener {
    @Inject
    private Logger log;
    @Inject
    private JobContext jobContext;

    public void afterWrite(List<Object> items) throws Exception {
        this.log.info("Persisting " + items.size() + " contacts");
    }

    public void beforeWrite(List<Object> items) throws Exception {
        this.log.info("Preparing to persist " + items.size() + " contacts");
    }

    public void onWriteError(List<Object> items, Exception ex) throws Exception {
        this.log.info("Exception detected. Setting exit status");
        this.jobContext.setExitStatus("Error : " + ex.getMessage());
    }
}

