/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.NoSuchJobException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.enterprise.inject.Model;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.as.quickstarts.batch.controller.JobData;

@Model
public class BatchController {
    @Inject
    private FacesContext facesContext;
    @Inject
    private Logger log;
    private String fileName = "temp-file.txt";
    private boolean generateWithError;
    @Min(value=0L)
    @Max(value=1000000L)
    private @Min(value=0L) @Max(value=1000000L) Integer numRecords = 10;

    public void generate() throws IOException {
        File tempFile = new File(System.getProperty("java.io.tmpdir"), this.fileName);
        try (BufferedWriter bos = new BufferedWriter(new FileWriter(tempFile, false));){
            this.log.info("Starting to generate " + this.numRecords + " records in file " + tempFile);
            String previousName = null;
            for (int x = 0; x < this.numRecords; ++x) {
                String name = RandomStringUtils.randomAlphabetic((int)10);
                String phone = RandomStringUtils.randomNumeric((int)9);
                if (this.generateWithError && x == this.numRecords / 2) {
                    name = previousName;
                }
                String record = x + 1 + "|" + name + "|" + phone;
                bos.write(record + "\n");
                previousName = name;
            }
            this.log.info("File generated at " + tempFile);
            this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "File generated with " + this.numRecords + " records to be imported. File name: " + this.getFileName(), null));
            if (this.generateWithError) {
                this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Attention: This file contains duplicate records for test purpose.", null));
            }
        }
    }

    public void generateFileAndStarJob() throws IOException {
        this.generate();
        this.startImport();
    }

    public void startImport() {
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        Properties jobParameters = new Properties();
        jobParameters.setProperty("fileName", this.getFileName());
        long execID = jobOperator.start("import-file", jobParameters);
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "New job execution #" + execID + " running. Importing file:" + this.getFileName(), null));
    }

    public Set<JobData> getJobsExecution() {
        TreeSet<JobData> jobsData = new TreeSet<JobData>((Comparator<JobData>)new /* Unavailable Anonymous Inner Class!! */);
        HashMap<Long, JobExecution> jobIntances = new HashMap<Long, JobExecution>();
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        try {
            List instances = jobOperator.getJobInstances("import-file", 0, jobOperator.getJobInstanceCount("import-file"));
            for (JobInstance ji : instances) {
                List executions = jobOperator.getJobExecutions(ji);
                for (JobExecution jobExecution : executions) {
                    if (jobIntances.get(ji.getInstanceId()) == null) {
                        jobIntances.put(ji.getInstanceId(), jobExecution);
                    }
                    JobExecution existing = (JobExecution)jobIntances.get(ji.getInstanceId());
                    if (jobExecution.getExecutionId() <= existing.getExecutionId()) continue;
                    jobIntances.put(ji.getInstanceId(), jobExecution);
                }
            }
            for (Long instaceId : jobIntances.keySet()) {
                JobExecution jobExecution = (JobExecution)jobIntances.get(instaceId);
                JobInstance ji = jobOperator.getJobInstance(jobExecution.getExecutionId());
                Properties parameters = jobOperator.getParameters(jobExecution.getExecutionId());
                jobsData.add(new JobData(Long.valueOf(ji.getInstanceId()), Long.valueOf(jobExecution.getExecutionId()), ji.getJobName(), jobExecution.getCreateTime(), jobExecution.getEndTime(), jobExecution.getBatchStatus(), parameters, jobExecution.getExitStatus()));
            }
        }
        catch (NoSuchJobException noSuchJobException) {
            // empty catch block
        }
        return jobsData;
    }

    public void restartJob(int executionId) {
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        Properties jobParameters = jobOperator.getParameters((long)executionId);
        jobParameters.setProperty("restartedOnce", "true");
        long newExecutionId = jobOperator.restart((long)executionId, jobParameters);
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "Execution " + executionId + " restarted! New execution id: " + newExecutionId, null));
    }

    public Integer getNumRecords() {
        return this.numRecords;
    }

    public void setNumRecords(Integer numRecords) {
        this.numRecords = numRecords;
    }

    public boolean isGenerateWithError() {
        return this.generateWithError;
    }

    public void setGenerateWithError(boolean generateWithError) {
        this.generateWithError = generateWithError;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

