/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.batch.job.listener;

import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.api.listener.AbstractJobListener;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="jobListener")
public class JobListener
extends AbstractJobListener {
    @Inject
    private Logger log;
    @Inject
    private JobContext jobContext;

    public void beforeJob() throws Exception {
        this.log.info(String.format("Job %s - Execution #%d starting.", this.jobContext.getJobName(), this.jobContext.getExecutionId()));
    }

    public void afterJob() throws Exception {
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        Properties jobParameters = jobOperator.getParameters(this.jobContext.getExecutionId());
        if (jobParameters.get("restartedOnce") != null && this.jobContext.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
            this.log.info("Job already restarted once! Abandoning it forever");
            jobOperator.abandon(this.jobContext.getExecutionId());
        }
        this.log.info(String.format("Job %s - Execution #%d finished. Status: %s", this.jobContext.getJobName(), this.jobContext.getExecutionId(), this.jobContext.getBatchStatus()));
    }
}

