/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.cdi.service;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.cdi.service.History;
import org.jboss.as.quickstarts.cdi.service.Item;
import org.jboss.as.quickstarts.cdi.service.ItemServiceBean;

@Named(value="itemBean")
@RequestScoped
public class ItemBean {
    @Inject
    private ItemServiceBean itemService;
    @Inject
    private FacesContext context;
    private List<Item> items;
    private List<String> itemHistory;
    private String name;
    private static final String EMPTY_STRING = "";

    public void add() {
        if (this.name == EMPTY_STRING) {
            FacesMessage fm = new FacesMessage("Name can't be empty");
            this.context.addMessage(fm.getSummary(), fm);
            this.refresh();
            return;
        }
        Item item = new Item();
        item.setName(this.name);
        this.itemService.create(item);
        this.name = EMPTY_STRING;
        this.refresh();
    }

    private void refresh() {
        this.itemHistory = History.getItemHistory();
        this.items = this.itemService.getList();
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getItemHistory() {
        return this.itemHistory;
    }

    public void setItemHistory(List<String> itemHistory) {
        this.itemHistory = itemHistory;
    }
}

