/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.cdi.veto;

import java.util.logging.Logger;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.jboss.as.quickstart.cdi.veto.model.Car;

public class CarManager {
    @Inject
    private EntityManager em;
    @Inject
    private UserTransaction utx;
    private Long id;
    private Logger log = Logger.getLogger(CarManager.class.getSimpleName());

    public void setId(Long id) {
        this.id = id;
    }

    @Produces
    public Car getCar() {
        if (this.id == null) {
            this.log.info("Returning new instance of Car");
            return new Car();
        }
        this.log.info("Finding instance of Car with id " + this.id);
        return (Car)this.em.find(Car.class, (Object)this.id);
    }

    public void save(Car car) {
        try {
            this.utx.begin();
            this.em.joinTransaction();
            this.em.persist((Object)car);
            this.utx.commit();
        }
        catch (Exception e) {
            this.log.severe("Transaction Error: " + e.getMessage());
        }
    }
}

