/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.deltaspike.authorization;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.as.quickstarts.deltaspike.authorization.AdminAllowed;
import org.jboss.as.quickstarts.deltaspike.authorization.EmployeeAllowed;

@Named
public class Controller {
    @Inject
    private FacesContext facesContext;

    @EmployeeAllowed
    public void employeeMethod() {
        this.facesContext.addMessage(null, new FacesMessage("You executed a @EmployeeAllowed method"));
    }

    @AdminAllowed
    public void adminMethod() {
        this.facesContext.addMessage(null, new FacesMessage("You executed a @AdminAllowed method"));
    }

    public void logout() throws IOException {
        HttpSession session = (HttpSession)this.facesContext.getExternalContext().getSession(false);
        session.invalidate();
        HttpServletResponse response = (HttpServletResponse)this.facesContext.getExternalContext().getResponse();
        response.sendRedirect("index.html");
        this.facesContext.responseComplete();
    }

    public String getStackTrace() {
        Throwable throwable = (Throwable)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("javax.servlet.error.exception");
        StringBuilder builder = new StringBuilder();
        builder.append(throwable.getMessage()).append("\n");
        for (StackTraceElement element : throwable.getStackTrace()) {
            builder.append(element).append("\n");
        }
        return builder.toString();
    }
}

