/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb.asynchronous;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.jboss.as.quickstarts.ejb.asynchronous.AnotherAsynchronousAccess;
import org.jboss.as.quickstarts.ejb.asynchronous.AsynchronousAccess;
import org.jboss.as.quickstarts.ejb.asynchronous.ParallelAccess;

@Stateless
public class ParallelAccessBean
implements ParallelAccess {
    private static final Logger LOGGER = Logger.getLogger(ParallelAccessBean.class.getName());
    @EJB
    private AsynchronousAccess asyncBean;
    @EJB
    private AnotherAsynchronousAccess anotherBean;

    @Override
    public Collection<String> invokeAsyncParallel() {
        ArrayList<String> results = new ArrayList<String>();
        Future<String> call1 = this.asyncBean.longerRunning(5000L);
        Future<String> call2 = this.asyncBean.longerRunning(3000L);
        try {
            results.add(call1.get());
            results.add(call2.get());
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Asynchronous call was interrupted!", e);
            throw new RuntimeException("Asynchronous call was interrupted!", e);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "Asynchronous call failed!", e);
            throw new RuntimeException("Asynchronous call failed!", e);
        }
        return results;
    }

    @Override
    public void callInterfaceAnnotatedMethod() {
        Future<String> call1 = this.anotherBean.interfaceAsync(500L);
        try {
            LOGGER.info("CALL result " + call1.get());
        }
        catch (Exception e) {
            throw new RuntimeException("Asynchronous (interface annotated) method can not be called!", e);
        }
    }
}

