/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb_security_programmatic_auth;

import java.util.Hashtable;
import java.util.concurrent.Callable;
import javax.ejb.EJBAccessException;
import javax.naming.InitialContext;
import org.jboss.as.quickstarts.ejb_security_programmatic_auth.SecuredEJBRemote;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.sasl.SaslMechanismSelector;

public class RemoteClient {
    static final Callable<String> callable = () -> {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
        jndiProperties.put("java.naming.provider.url", "remote+http://localhost:8080");
        InitialContext context = new InitialContext(jndiProperties);
        SecuredEJBRemote reference = (SecuredEJBRemote)context.lookup("ejb:/ejb-security-programmatic-auth/SecuredEJB!" + SecuredEJBRemote.class.getName());
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n\n");
        builder.append("Called secured bean, caller principal " + reference.getSecurityInformation());
        boolean hasAdminPermission = false;
        try {
            hasAdminPermission = reference.administrativeMethod();
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
        builder.append("\n\nPrincipal has admin permission: " + hasAdminPermission);
        builder.append("\n\n* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n\n");
        return builder.toString();
    };

    public static void main(String[] args) throws Exception {
        AuthenticationConfiguration common = AuthenticationConfiguration.empty().setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism("DIGEST-MD5"));
        AuthenticationConfiguration quickstartUser = common.useName("quickstartUser").usePassword("quickstartPwd1!");
        AuthenticationContext authCtx1 = AuthenticationContext.empty().with(MatchRule.ALL, quickstartUser);
        System.out.println((String)authCtx1.runCallable(callable));
        AuthenticationConfiguration superUser = common.useName("superUser").usePassword("superPwd1!");
        AuthenticationContext authCtx2 = AuthenticationContext.empty().with(MatchRule.ALL, superUser);
        System.out.println((String)authCtx2.runCallable(callable));
    }
}

