/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejbTimer;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ScheduleExpression;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Singleton
@Startup
public class TimeoutExample {
    @Resource
    private TimerService timerService;

    @Timeout
    public void scheduler(Timer timer) {
        Date currentTime = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z");
        System.out.println("TimeoutExample.scheduler() " + timer.getInfo() + simpleDateFormat.format(currentTime));
    }

    @PostConstruct
    public void initialize() {
        ScheduleExpression se = new ScheduleExpression();
        se.hour("*").minute("*").second("0/3");
        this.timerService.createCalendarTimer(se, new TimerConfig((Serializable)((Object)"EJB timer service timeout at "), false));
    }

    @PreDestroy
    public void stop() {
        System.out.println("EJB Timer: Stop timers.");
        for (Timer timer : this.timerService.getTimers()) {
            System.out.println("Stopping timer: " + timer.getInfo());
            timer.cancel();
        }
    }
}

