/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ha.singleton.service.primary;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.quickstarts.ha.singleton.service.primary.ServiceActivator;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.group.Node;

class QueryingService
implements Service<Void> {
    private Logger LOG = Logger.getLogger(this.getClass());
    private ScheduledExecutorService executor;

    QueryingService() {
    }

    public void start(StartContext context) throws StartException {
        this.LOG.info((Object)"Querying service is starting.");
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            ServiceController service = context.getController().getServiceContainer().getService(ServiceActivator.SINGLETON_SERVICE_NAME);
            try {
                Node node = (Node)service.awaitValue(5L, TimeUnit.SECONDS);
                this.LOG.infof("Singleton service is running on node '%s'.", (Object)node);
            }
            catch (IllegalStateException | InterruptedException | TimeoutException e) {
                this.LOG.warn((Object)"Failed to query singleton service.");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public void stop(StopContext context) {
        this.LOG.info((Object)"Querying service is stopping.");
        this.executor.shutdown();
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

