/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.jms;

import java.util.Properties;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HelloWorldJMSClient {
    private static final Logger log = Logger.getLogger(HelloWorldJMSClient.class.getName());
    private static final String DEFAULT_MESSAGE = "Hello, World!";
    private static final String DEFAULT_CONNECTION_FACTORY = "jms/RemoteConnectionFactory";
    private static final String DEFAULT_DESTINATION = "jms/queue/test";
    private static final String DEFAULT_MESSAGE_COUNT = "1";
    private static final String DEFAULT_USERNAME = "quickstartUser";
    private static final String DEFAULT_PASSWORD = "quickstartPwd1!";
    private static final String INITIAL_CONTEXT_FACTORY = "org.wildfly.naming.client.WildFlyInitialContextFactory";
    private static final String PROVIDER_URL = "http-remoting://127.0.0.1:8080";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Context namingContext = null;
        try {
            String userName = System.getProperty("username", DEFAULT_USERNAME);
            String password = System.getProperty("password", DEFAULT_PASSWORD);
            Properties env = new Properties();
            env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
            env.put("java.naming.provider.url", System.getProperty("java.naming.provider.url", PROVIDER_URL));
            env.put("java.naming.security.principal", userName);
            env.put("java.naming.security.credentials", password);
            namingContext = new InitialContext(env);
            String connectionFactoryString = System.getProperty("connection.factory", DEFAULT_CONNECTION_FACTORY);
            log.info("Attempting to acquire connection factory \"" + connectionFactoryString + "\"");
            ConnectionFactory connectionFactory = (ConnectionFactory)namingContext.lookup(connectionFactoryString);
            log.info("Found connection factory \"" + connectionFactoryString + "\" in JNDI");
            String destinationString = System.getProperty("destination", DEFAULT_DESTINATION);
            log.info("Attempting to acquire destination \"" + destinationString + "\"");
            Destination destination = (Destination)namingContext.lookup(destinationString);
            log.info("Found destination \"" + destinationString + "\" in JNDI");
            int count = Integer.parseInt(System.getProperty("message.count", DEFAULT_MESSAGE_COUNT));
            String content = System.getProperty("message.content", DEFAULT_MESSAGE);
            try (JMSContext context = connectionFactory.createContext(userName, password);){
                log.info("Sending " + count + " messages with content: " + content);
                for (int i = 0; i < count; ++i) {
                    context.createProducer().send(destination, content);
                }
                JMSConsumer consumer = context.createConsumer(destination);
                for (int i = 0; i < count; ++i) {
                    String text = (String)consumer.receiveBody(String.class, 5000L);
                    log.info("Received message with content " + text);
                }
            }
        }
        catch (NamingException e) {
            log.severe(e.getMessage());
        }
        finally {
            if (namingContext != null) {
                try {
                    namingContext.close();
                }
                catch (NamingException e) {
                    log.severe(e.getMessage());
                }
            }
        }
    }
}

