/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.mbeanhelloworld.mbean;

import java.lang.management.ManagementFactory;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class AbstractComponentMBean {
    private static final Logger log = Logger.getLogger(AbstractComponentMBean.class.getName());
    private final String domain;
    private String name;
    private MBeanServer mbeanServer;
    private ObjectName objectName = null;

    public AbstractComponentMBean(String domain) {
        this.domain = domain;
    }

    @PostConstruct
    protected void startup() {
        this.name = this.getClass().getSimpleName();
        try {
            this.objectName = new ObjectName(this.domain, "type", this.name);
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.mbeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error during registration of " + this.name + " into JMX:" + e, e);
        }
    }

    @PreDestroy
    protected void destroy() {
        log.info("# << -- Destroy : " + this.name);
        try {
            this.mbeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error during unregistration of " + this.name + " into JMX:" + e, e);
        }
    }
}

