/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.mbeanhelloworld.mbean;

import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.jboss.as.quickstarts.mbeanhelloworld.mbean.AbstractComponentMBean;
import org.jboss.as.quickstarts.mbeanhelloworld.mbean.IHelloWorldMXBean;
import org.jboss.as.quickstarts.mbeanhelloworld.service.HelloService;

@Singleton
@Startup
public class MXComponentHelloWorld
extends AbstractComponentMBean
implements IHelloWorldMXBean {
    private String welcomeMessage = "Hello";
    private AtomicLong count = new AtomicLong(0L);
    @Inject
    HelloService helloService;

    public MXComponentHelloWorld() {
        super("quickstarts");
    }

    public long getCount() {
        return this.count.get();
    }

    public void setWelcomeMessage(String message) {
        if (message != null && message.trim().length() > 0) {
            this.welcomeMessage = message;
        }
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String sayHello(String name) {
        this.count.incrementAndGet();
        return this.helloService.createHelloMessage(this.welcomeMessage, name);
    }
}

