/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.jaxrsjwt.client;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.quickstarts.jaxrsjwt.model.Jwt;

public class JwtRestClient {
    private static final String AUTHZ_HEADER = "Authorization";
    private static final String REST_TARGET_URL = "http://localhost:8080/jaxrs-jwt-service/rest";
    private static final String ADMIN_NAME = "admin";
    private static final String ADMIN_PW = "adminpw";
    private static final String CUSTOMER_NAME = "customer";
    private static final String CUSTOMER_PW = "customerpw";
    private String username;
    private String password;

    public JwtRestClient() {
        this.username = null;
        this.password = null;
    }

    public JwtRestClient(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static void main(String[] args) {
        JwtRestClient adminClient = new JwtRestClient(ADMIN_NAME, ADMIN_PW);
        adminClient.test(true);
        JwtRestClient customerClient = new JwtRestClient(CUSTOMER_NAME, CUSTOMER_PW);
        customerClient.test(true);
        JwtRestClient noToken = new JwtRestClient();
        noToken.test(false);
    }

    public void test(boolean obtainToken) {
        System.out.println("------------------------------");
        System.out.println("Testing " + (this.username != null ? this.username : "without token") + " ");
        System.out.println("------------------------------");
        String authzHeaderValue = null;
        if (obtainToken) {
            System.out.println("Obtaining JWT...");
            Form form = new Form();
            form.param("username", this.username);
            form.param("password", this.password);
            Jwt jwt = (Jwt)ClientBuilder.newClient().target(REST_TARGET_URL).path("/token").request().post(Entity.entity((Object)form, (String)"application/x-www-form-urlencoded"), Jwt.class);
            if (jwt == null) {
                System.out.println("Failed to obtain JWT.");
                return;
            }
            authzHeaderValue = "Bearer " + jwt.getToken();
        }
        this.getUsingJwt("/protected", authzHeaderValue);
        this.getUsingJwt("/public", authzHeaderValue);
        this.getUsingJwt("/customer", authzHeaderValue);
        this.getUsingJwt("/claims", authzHeaderValue);
    }

    private void getUsingJwt(String path, String authzHeaderValue) {
        System.out.println("Accessing " + path + "...");
        Response response = null;
        response = authzHeaderValue != null ? ClientBuilder.newClient().target(REST_TARGET_URL).path(path).request().header(AUTHZ_HEADER, (Object)authzHeaderValue).get() : ClientBuilder.newClient().target(REST_TARGET_URL).path(path).request().get();
        System.out.println("Status: " + response.getStatus() + "\n" + (response.getStatus() == 200 ? (String)response.readEntity(String.class) + "\n" : ""));
        response.close();
    }
}

