/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.jsonp;

import java.io.Reader;
import java.io.StringReader;
import javax.enterprise.inject.Model;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonParser;
import org.jboss.as.quickstarts.jsonp.Person;

@Model
public class JsonController {
    @Inject
    private Person person;
    private String jsonString;
    private String parsedResult;

    public void generateJson() {
        this.jsonString = Json.createObjectBuilder().add("name", this.person.getName()).add("age", this.person.getAge().intValue()).add("enabled", this.person.getEnabled().booleanValue()).add("phones", Json.createArrayBuilder().add(this.person.getPhone1()).add(this.person.getPhone2())).add("addrees", Json.createObjectBuilder().add("street", this.person.getAddressStreet()).add("apt", this.person.getAddressApt().intValue()).add("city", this.person.getAddressCity()).add("zip", this.person.getAddressZip())).build().toString();
    }

    public void parseJsonStream() {
        StringBuilder sb = new StringBuilder();
        String json = this.getJsonString();
        try {
            JsonParser parser = Json.createParser((Reader)new StringReader(json));
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                if (event.equals((Object)JsonParser.Event.KEY_NAME)) {
                    sb.append(" - - - -  >  Key: " + parser.getString() + "  < - - - - - \n");
                }
                if (event.equals((Object)JsonParser.Event.VALUE_STRING)) {
                    sb.append("Value as String: " + parser.getString() + "\n");
                }
                if (event.equals((Object)JsonParser.Event.VALUE_NUMBER)) {
                    sb.append("Value as Number: " + parser.getInt() + "\n");
                }
                if (event.equals((Object)JsonParser.Event.VALUE_TRUE)) {
                    sb.append("Value as Boolean: true\n");
                }
                if (!event.equals((Object)JsonParser.Event.VALUE_FALSE)) continue;
                sb.append("Value as Boolean: false \n");
            }
        }
        catch (JsonException e) {
            FacesContext.getCurrentInstance().addMessage("form:parsed", new FacesMessage(e.getMessage()));
        }
        this.parsedResult = sb.toString();
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public String getParsedResult() {
        return this.parsedResult;
    }
}

